package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RepositoryDigestMirrorsFluentImpl<A extends RepositoryDigestMirrorsFluent<A>> extends BaseFluent<A> implements RepositoryDigestMirrorsFluent<A>{
  public RepositoryDigestMirrorsFluentImpl() {
  }
  public RepositoryDigestMirrorsFluentImpl(RepositoryDigestMirrors instance) {
    if (instance != null) {
      this.withAllowMirrorByTags(instance.getAllowMirrorByTags());
      this.withMirrors(instance.getMirrors());
      this.withSource(instance.getSource());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Boolean allowMirrorByTags;
  private List<String> mirrors = new ArrayList<String>();
  private String source;
  private Map<String,Object> additionalProperties;
  public Boolean getAllowMirrorByTags() {
    return this.allowMirrorByTags;
  }
  public A withAllowMirrorByTags(Boolean allowMirrorByTags) {
    this.allowMirrorByTags=allowMirrorByTags; return (A) this;
  }
  public Boolean hasAllowMirrorByTags() {
    return this.allowMirrorByTags != null;
  }
  public A addToMirrors(int index,String item) {
    if (this.mirrors == null) {this.mirrors = new ArrayList<String>();}
    this.mirrors.add(index, item);
    return (A)this;
  }
  public A setToMirrors(int index,String item) {
    if (this.mirrors == null) {this.mirrors = new ArrayList<String>();}
    this.mirrors.set(index, item); return (A)this;
  }
  public A addToMirrors(java.lang.String... items) {
    if (this.mirrors == null) {this.mirrors = new ArrayList<String>();}
    for (String item : items) {this.mirrors.add(item);} return (A)this;
  }
  public A addAllToMirrors(Collection<String> items) {
    if (this.mirrors == null) {this.mirrors = new ArrayList<String>();}
    for (String item : items) {this.mirrors.add(item);} return (A)this;
  }
  public A removeFromMirrors(java.lang.String... items) {
    for (String item : items) {if (this.mirrors!= null){ this.mirrors.remove(item);}} return (A)this;
  }
  public A removeAllFromMirrors(Collection<String> items) {
    for (String item : items) {if (this.mirrors!= null){ this.mirrors.remove(item);}} return (A)this;
  }
  public List<String> getMirrors() {
    return this.mirrors;
  }
  public String getMirror(int index) {
    return this.mirrors.get(index);
  }
  public String getFirstMirror() {
    return this.mirrors.get(0);
  }
  public String getLastMirror() {
    return this.mirrors.get(mirrors.size() - 1);
  }
  public String getMatchingMirror(Predicate<String> predicate) {
    for (String item: mirrors) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingMirror(Predicate<String> predicate) {
    for (String item: mirrors) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMirrors(List<String> mirrors) {
    if (mirrors != null) {this.mirrors = new ArrayList(); for (String item : mirrors){this.addToMirrors(item);}} else { this.mirrors = null;} return (A) this;
  }
  public A withMirrors(java.lang.String... mirrors) {
    if (this.mirrors != null) {this.mirrors.clear(); _visitables.remove("mirrors"); }
    if (mirrors != null) {for (String item :mirrors){ this.addToMirrors(item);}} return (A) this;
  }
  public Boolean hasMirrors() {
    return mirrors != null && !mirrors.isEmpty();
  }
  public String getSource() {
    return this.source;
  }
  public A withSource(String source) {
    this.source=source; return (A) this;
  }
  public Boolean hasSource() {
    return this.source != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RepositoryDigestMirrorsFluentImpl that = (RepositoryDigestMirrorsFluentImpl) o;
    if (!java.util.Objects.equals(allowMirrorByTags, that.allowMirrorByTags)) return false;

    if (!java.util.Objects.equals(mirrors, that.mirrors)) return false;

    if (!java.util.Objects.equals(source, that.source)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowMirrorByTags,  mirrors,  source,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowMirrorByTags != null) { sb.append("allowMirrorByTags:"); sb.append(allowMirrorByTags + ","); }
    if (mirrors != null && !mirrors.isEmpty()) { sb.append("mirrors:"); sb.append(mirrors + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withAllowMirrorByTags() {
    return withAllowMirrorByTags(true);
  }
  
}