package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AlibabaCloudPlatformStatusBuilder extends AlibabaCloudPlatformStatusFluent<AlibabaCloudPlatformStatusBuilder> implements VisitableBuilder<AlibabaCloudPlatformStatus,AlibabaCloudPlatformStatusBuilder>{
  public AlibabaCloudPlatformStatusBuilder() {
    this(false);
  }
  public AlibabaCloudPlatformStatusBuilder(Boolean validationEnabled) {
    this(new AlibabaCloudPlatformStatus(), validationEnabled);
  }
  public AlibabaCloudPlatformStatusBuilder(AlibabaCloudPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AlibabaCloudPlatformStatusBuilder(AlibabaCloudPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AlibabaCloudPlatformStatus(), validationEnabled);
  }
  public AlibabaCloudPlatformStatusBuilder(AlibabaCloudPlatformStatusFluent<?> fluent,AlibabaCloudPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public AlibabaCloudPlatformStatusBuilder(AlibabaCloudPlatformStatusFluent<?> fluent,AlibabaCloudPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AlibabaCloudPlatformStatus());

    if (instance != null) {
      fluent.withRegion(instance.getRegion());
      fluent.withResourceGroupID(instance.getResourceGroupID());
      fluent.withResourceTags(instance.getResourceTags());
      fluent.withRegion(instance.getRegion());
      fluent.withResourceGroupID(instance.getResourceGroupID());
      fluent.withResourceTags(instance.getResourceTags());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AlibabaCloudPlatformStatusBuilder(AlibabaCloudPlatformStatus instance) {
    this(instance,false);
  }
  public AlibabaCloudPlatformStatusBuilder(AlibabaCloudPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AlibabaCloudPlatformStatus());

    if (instance != null) {
      this.withRegion(instance.getRegion());
      this.withResourceGroupID(instance.getResourceGroupID());
      this.withResourceTags(instance.getResourceTags());
      this.withRegion(instance.getRegion());
      this.withResourceGroupID(instance.getResourceGroupID());
      this.withResourceTags(instance.getResourceTags());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AlibabaCloudPlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public AlibabaCloudPlatformStatus build() {
    AlibabaCloudPlatformStatus buildable = new AlibabaCloudPlatformStatus(fluent.getRegion(),fluent.getResourceGroupID(),fluent.buildResourceTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}