package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildDefaultsBuilder extends BuildDefaultsFluent<BuildDefaultsBuilder> implements VisitableBuilder<BuildDefaults,BuildDefaultsBuilder>{
  public BuildDefaultsBuilder() {
    this(false);
  }
  public BuildDefaultsBuilder(Boolean validationEnabled) {
    this(new BuildDefaults(), validationEnabled);
  }
  public BuildDefaultsBuilder(BuildDefaultsFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildDefaultsBuilder(BuildDefaultsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildDefaults(), validationEnabled);
  }
  public BuildDefaultsBuilder(BuildDefaultsFluent<?> fluent,BuildDefaults instance) {
    this(fluent, instance, false);
  }
  public BuildDefaultsBuilder(BuildDefaultsFluent<?> fluent,BuildDefaults instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BuildDefaults());

    if (instance != null) {
      fluent.withDefaultProxy(instance.getDefaultProxy());
      fluent.withEnv(instance.getEnv());
      fluent.withGitProxy(instance.getGitProxy());
      fluent.withImageLabels(instance.getImageLabels());
      fluent.withResources(instance.getResources());
      fluent.withDefaultProxy(instance.getDefaultProxy());
      fluent.withEnv(instance.getEnv());
      fluent.withGitProxy(instance.getGitProxy());
      fluent.withImageLabels(instance.getImageLabels());
      fluent.withResources(instance.getResources());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildDefaultsBuilder(BuildDefaults instance) {
    this(instance,false);
  }
  public BuildDefaultsBuilder(BuildDefaults instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BuildDefaults());

    if (instance != null) {
      this.withDefaultProxy(instance.getDefaultProxy());
      this.withEnv(instance.getEnv());
      this.withGitProxy(instance.getGitProxy());
      this.withImageLabels(instance.getImageLabels());
      this.withResources(instance.getResources());
      this.withDefaultProxy(instance.getDefaultProxy());
      this.withEnv(instance.getEnv());
      this.withGitProxy(instance.getGitProxy());
      this.withImageLabels(instance.getImageLabels());
      this.withResources(instance.getResources());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildDefaultsFluent<?> fluent;
  Boolean validationEnabled;
  public BuildDefaults build() {
    BuildDefaults buildable = new BuildDefaults(fluent.buildDefaultProxy(),fluent.getEnv(),fluent.buildGitProxy(),fluent.buildImageLabels(),fluent.buildResources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}