package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FeatureGateAttributesBuilder extends FeatureGateAttributesFluent<FeatureGateAttributesBuilder> implements VisitableBuilder<FeatureGateAttributes,FeatureGateAttributesBuilder>{
  public FeatureGateAttributesBuilder() {
    this(false);
  }
  public FeatureGateAttributesBuilder(Boolean validationEnabled) {
    this(new FeatureGateAttributes(), validationEnabled);
  }
  public FeatureGateAttributesBuilder(FeatureGateAttributesFluent<?> fluent) {
    this(fluent, false);
  }
  public FeatureGateAttributesBuilder(FeatureGateAttributesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FeatureGateAttributes(), validationEnabled);
  }
  public FeatureGateAttributesBuilder(FeatureGateAttributesFluent<?> fluent,FeatureGateAttributes instance) {
    this(fluent, instance, false);
  }
  public FeatureGateAttributesBuilder(FeatureGateAttributesFluent<?> fluent,FeatureGateAttributes instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new FeatureGateAttributes());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FeatureGateAttributesBuilder(FeatureGateAttributes instance) {
    this(instance,false);
  }
  public FeatureGateAttributesBuilder(FeatureGateAttributes instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new FeatureGateAttributes());

    if (instance != null) {
      this.withName(instance.getName());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FeatureGateAttributesFluent<?> fluent;
  Boolean validationEnabled;
  public FeatureGateAttributes build() {
    FeatureGateAttributes buildable = new FeatureGateAttributes(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}