package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitLabIdentityProviderBuilder extends GitLabIdentityProviderFluent<GitLabIdentityProviderBuilder> implements VisitableBuilder<GitLabIdentityProvider,GitLabIdentityProviderBuilder>{
  public GitLabIdentityProviderBuilder() {
    this(false);
  }
  public GitLabIdentityProviderBuilder(Boolean validationEnabled) {
    this(new GitLabIdentityProvider(), validationEnabled);
  }
  public GitLabIdentityProviderBuilder(GitLabIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public GitLabIdentityProviderBuilder(GitLabIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitLabIdentityProvider(), validationEnabled);
  }
  public GitLabIdentityProviderBuilder(GitLabIdentityProviderFluent<?> fluent,GitLabIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public GitLabIdentityProviderBuilder(GitLabIdentityProviderFluent<?> fluent,GitLabIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GitLabIdentityProvider());

    if (instance != null) {
      fluent.withCa(instance.getCa());
      fluent.withClientID(instance.getClientID());
      fluent.withClientSecret(instance.getClientSecret());
      fluent.withUrl(instance.getUrl());
      fluent.withCa(instance.getCa());
      fluent.withClientID(instance.getClientID());
      fluent.withClientSecret(instance.getClientSecret());
      fluent.withUrl(instance.getUrl());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitLabIdentityProviderBuilder(GitLabIdentityProvider instance) {
    this(instance,false);
  }
  public GitLabIdentityProviderBuilder(GitLabIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GitLabIdentityProvider());

    if (instance != null) {
      this.withCa(instance.getCa());
      this.withClientID(instance.getClientID());
      this.withClientSecret(instance.getClientSecret());
      this.withUrl(instance.getUrl());
      this.withCa(instance.getCa());
      this.withClientID(instance.getClientID());
      this.withClientSecret(instance.getClientSecret());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitLabIdentityProviderFluent<?> fluent;
  Boolean validationEnabled;
  public GitLabIdentityProvider build() {
    GitLabIdentityProvider buildable = new GitLabIdentityProvider(fluent.buildCa(),fluent.getClientID(),fluent.buildClientSecret(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}