package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MTUMigrationValuesBuilder extends MTUMigrationValuesFluent<MTUMigrationValuesBuilder> implements VisitableBuilder<MTUMigrationValues,MTUMigrationValuesBuilder>{
  public MTUMigrationValuesBuilder() {
    this(false);
  }
  public MTUMigrationValuesBuilder(Boolean validationEnabled) {
    this(new MTUMigrationValues(), validationEnabled);
  }
  public MTUMigrationValuesBuilder(MTUMigrationValuesFluent<?> fluent) {
    this(fluent, false);
  }
  public MTUMigrationValuesBuilder(MTUMigrationValuesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MTUMigrationValues(), validationEnabled);
  }
  public MTUMigrationValuesBuilder(MTUMigrationValuesFluent<?> fluent,MTUMigrationValues instance) {
    this(fluent, instance, false);
  }
  public MTUMigrationValuesBuilder(MTUMigrationValuesFluent<?> fluent,MTUMigrationValues instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MTUMigrationValues());

    if (instance != null) {
      fluent.withFrom(instance.getFrom());
      fluent.withTo(instance.getTo());
      fluent.withFrom(instance.getFrom());
      fluent.withTo(instance.getTo());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MTUMigrationValuesBuilder(MTUMigrationValues instance) {
    this(instance,false);
  }
  public MTUMigrationValuesBuilder(MTUMigrationValues instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MTUMigrationValues());

    if (instance != null) {
      this.withFrom(instance.getFrom());
      this.withTo(instance.getTo());
      this.withFrom(instance.getFrom());
      this.withTo(instance.getTo());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MTUMigrationValuesFluent<?> fluent;
  Boolean validationEnabled;
  public MTUMigrationValues build() {
    MTUMigrationValues buildable = new MTUMigrationValues(fluent.getFrom(),fluent.getTo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}