package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OvirtPlatformStatusBuilder extends OvirtPlatformStatusFluent<OvirtPlatformStatusBuilder> implements VisitableBuilder<OvirtPlatformStatus,OvirtPlatformStatusBuilder>{
  public OvirtPlatformStatusBuilder() {
    this(false);
  }
  public OvirtPlatformStatusBuilder(Boolean validationEnabled) {
    this(new OvirtPlatformStatus(), validationEnabled);
  }
  public OvirtPlatformStatusBuilder(OvirtPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OvirtPlatformStatusBuilder(OvirtPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OvirtPlatformStatus(), validationEnabled);
  }
  public OvirtPlatformStatusBuilder(OvirtPlatformStatusFluent<?> fluent,OvirtPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public OvirtPlatformStatusBuilder(OvirtPlatformStatusFluent<?> fluent,OvirtPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OvirtPlatformStatus());

    if (instance != null) {
      fluent.withApiServerInternalIP(instance.getApiServerInternalIP());
      fluent.withApiServerInternalIPs(instance.getApiServerInternalIPs());
      fluent.withIngressIP(instance.getIngressIP());
      fluent.withIngressIPs(instance.getIngressIPs());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withNodeDNSIP(instance.getNodeDNSIP());
      fluent.withApiServerInternalIP(instance.getApiServerInternalIP());
      fluent.withApiServerInternalIPs(instance.getApiServerInternalIPs());
      fluent.withIngressIP(instance.getIngressIP());
      fluent.withIngressIPs(instance.getIngressIPs());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withNodeDNSIP(instance.getNodeDNSIP());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OvirtPlatformStatusBuilder(OvirtPlatformStatus instance) {
    this(instance,false);
  }
  public OvirtPlatformStatusBuilder(OvirtPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OvirtPlatformStatus());

    if (instance != null) {
      this.withApiServerInternalIP(instance.getApiServerInternalIP());
      this.withApiServerInternalIPs(instance.getApiServerInternalIPs());
      this.withIngressIP(instance.getIngressIP());
      this.withIngressIPs(instance.getIngressIPs());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withNodeDNSIP(instance.getNodeDNSIP());
      this.withApiServerInternalIP(instance.getApiServerInternalIP());
      this.withApiServerInternalIPs(instance.getApiServerInternalIPs());
      this.withIngressIP(instance.getIngressIP());
      this.withIngressIPs(instance.getIngressIPs());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withNodeDNSIP(instance.getNodeDNSIP());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OvirtPlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public OvirtPlatformStatus build() {
    OvirtPlatformStatus buildable = new OvirtPlatformStatus(fluent.getApiServerInternalIP(),fluent.getApiServerInternalIPs(),fluent.getIngressIP(),fluent.getIngressIPs(),fluent.buildLoadBalancer(),fluent.getNodeDNSIP());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}