package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformSpecBuilder extends PlatformSpecFluent<PlatformSpecBuilder> implements VisitableBuilder<PlatformSpec,PlatformSpecBuilder>{
  public PlatformSpecBuilder() {
    this(false);
  }
  public PlatformSpecBuilder(Boolean validationEnabled) {
    this(new PlatformSpec(), validationEnabled);
  }
  public PlatformSpecBuilder(PlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformSpecBuilder(PlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PlatformSpec(), validationEnabled);
  }
  public PlatformSpecBuilder(PlatformSpecFluent<?> fluent,PlatformSpec instance) {
    this(fluent, instance, false);
  }
  public PlatformSpecBuilder(PlatformSpecFluent<?> fluent,PlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PlatformSpec());

    if (instance != null) {
      fluent.withAlibabaCloud(instance.getAlibabaCloud());
      fluent.withAws(instance.getAws());
      fluent.withAzure(instance.getAzure());
      fluent.withBaremetal(instance.getBaremetal());
      fluent.withEquinixMetal(instance.getEquinixMetal());
      fluent.withExternal(instance.getExternal());
      fluent.withGcp(instance.getGcp());
      fluent.withIbmcloud(instance.getIbmcloud());
      fluent.withKubevirt(instance.getKubevirt());
      fluent.withNutanix(instance.getNutanix());
      fluent.withOpenstack(instance.getOpenstack());
      fluent.withOvirt(instance.getOvirt());
      fluent.withPowervs(instance.getPowervs());
      fluent.withType(instance.getType());
      fluent.withVsphere(instance.getVsphere());
      fluent.withAlibabaCloud(instance.getAlibabaCloud());
      fluent.withAws(instance.getAws());
      fluent.withAzure(instance.getAzure());
      fluent.withBaremetal(instance.getBaremetal());
      fluent.withEquinixMetal(instance.getEquinixMetal());
      fluent.withExternal(instance.getExternal());
      fluent.withGcp(instance.getGcp());
      fluent.withIbmcloud(instance.getIbmcloud());
      fluent.withKubevirt(instance.getKubevirt());
      fluent.withNutanix(instance.getNutanix());
      fluent.withOpenstack(instance.getOpenstack());
      fluent.withOvirt(instance.getOvirt());
      fluent.withPowervs(instance.getPowervs());
      fluent.withType(instance.getType());
      fluent.withVsphere(instance.getVsphere());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformSpecBuilder(PlatformSpec instance) {
    this(instance,false);
  }
  public PlatformSpecBuilder(PlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PlatformSpec());

    if (instance != null) {
      this.withAlibabaCloud(instance.getAlibabaCloud());
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withBaremetal(instance.getBaremetal());
      this.withEquinixMetal(instance.getEquinixMetal());
      this.withExternal(instance.getExternal());
      this.withGcp(instance.getGcp());
      this.withIbmcloud(instance.getIbmcloud());
      this.withKubevirt(instance.getKubevirt());
      this.withNutanix(instance.getNutanix());
      this.withOpenstack(instance.getOpenstack());
      this.withOvirt(instance.getOvirt());
      this.withPowervs(instance.getPowervs());
      this.withType(instance.getType());
      this.withVsphere(instance.getVsphere());
      this.withAlibabaCloud(instance.getAlibabaCloud());
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withBaremetal(instance.getBaremetal());
      this.withEquinixMetal(instance.getEquinixMetal());
      this.withExternal(instance.getExternal());
      this.withGcp(instance.getGcp());
      this.withIbmcloud(instance.getIbmcloud());
      this.withKubevirt(instance.getKubevirt());
      this.withNutanix(instance.getNutanix());
      this.withOpenstack(instance.getOpenstack());
      this.withOvirt(instance.getOvirt());
      this.withPowervs(instance.getPowervs());
      this.withType(instance.getType());
      this.withVsphere(instance.getVsphere());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PlatformSpec build() {
    PlatformSpec buildable = new PlatformSpec(fluent.buildAlibabaCloud(),fluent.buildAws(),fluent.buildAzure(),fluent.buildBaremetal(),fluent.buildEquinixMetal(),fluent.buildExternal(),fluent.buildGcp(),fluent.buildIbmcloud(),fluent.buildKubevirt(),fluent.buildNutanix(),fluent.buildOpenstack(),fluent.buildOvirt(),fluent.buildPowervs(),fluent.getType(),fluent.buildVsphere());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}