package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PromQLClusterConditionBuilder extends PromQLClusterConditionFluent<PromQLClusterConditionBuilder> implements VisitableBuilder<PromQLClusterCondition,PromQLClusterConditionBuilder>{
  public PromQLClusterConditionBuilder() {
    this(false);
  }
  public PromQLClusterConditionBuilder(Boolean validationEnabled) {
    this(new PromQLClusterCondition(), validationEnabled);
  }
  public PromQLClusterConditionBuilder(PromQLClusterConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public PromQLClusterConditionBuilder(PromQLClusterConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PromQLClusterCondition(), validationEnabled);
  }
  public PromQLClusterConditionBuilder(PromQLClusterConditionFluent<?> fluent,PromQLClusterCondition instance) {
    this(fluent, instance, false);
  }
  public PromQLClusterConditionBuilder(PromQLClusterConditionFluent<?> fluent,PromQLClusterCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PromQLClusterCondition());

    if (instance != null) {
      fluent.withPromql(instance.getPromql());
      fluent.withPromql(instance.getPromql());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PromQLClusterConditionBuilder(PromQLClusterCondition instance) {
    this(instance,false);
  }
  public PromQLClusterConditionBuilder(PromQLClusterCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PromQLClusterCondition());

    if (instance != null) {
      this.withPromql(instance.getPromql());
      this.withPromql(instance.getPromql());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PromQLClusterConditionFluent<?> fluent;
  Boolean validationEnabled;
  public PromQLClusterCondition build() {
    PromQLClusterCondition buildable = new PromQLClusterCondition(fluent.getPromql());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}