package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TokenConfigBuilder extends TokenConfigFluent<TokenConfigBuilder> implements VisitableBuilder<TokenConfig,TokenConfigBuilder>{
  public TokenConfigBuilder() {
    this(false);
  }
  public TokenConfigBuilder(Boolean validationEnabled) {
    this(new TokenConfig(), validationEnabled);
  }
  public TokenConfigBuilder(TokenConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public TokenConfigBuilder(TokenConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TokenConfig(), validationEnabled);
  }
  public TokenConfigBuilder(TokenConfigFluent<?> fluent,TokenConfig instance) {
    this(fluent, instance, false);
  }
  public TokenConfigBuilder(TokenConfigFluent<?> fluent,TokenConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TokenConfig());

    if (instance != null) {
      fluent.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout());
      fluent.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
      fluent.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
      fluent.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout());
      fluent.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
      fluent.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TokenConfigBuilder(TokenConfig instance) {
    this(instance,false);
  }
  public TokenConfigBuilder(TokenConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TokenConfig());

    if (instance != null) {
      this.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout());
      this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
      this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
      this.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout());
      this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
      this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TokenConfigFluent<?> fluent;
  Boolean validationEnabled;
  public TokenConfig build() {
    TokenConfig buildable = new TokenConfig(fluent.getAccessTokenInactivityTimeout(),fluent.getAccessTokenInactivityTimeoutSeconds(),fluent.getAccessTokenMaxAgeSeconds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}