package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WebhookTokenAuthenticatorBuilder extends WebhookTokenAuthenticatorFluent<WebhookTokenAuthenticatorBuilder> implements VisitableBuilder<WebhookTokenAuthenticator,WebhookTokenAuthenticatorBuilder>{
  public WebhookTokenAuthenticatorBuilder() {
    this(false);
  }
  public WebhookTokenAuthenticatorBuilder(Boolean validationEnabled) {
    this(new WebhookTokenAuthenticator(), validationEnabled);
  }
  public WebhookTokenAuthenticatorBuilder(WebhookTokenAuthenticatorFluent<?> fluent) {
    this(fluent, false);
  }
  public WebhookTokenAuthenticatorBuilder(WebhookTokenAuthenticatorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WebhookTokenAuthenticator(), validationEnabled);
  }
  public WebhookTokenAuthenticatorBuilder(WebhookTokenAuthenticatorFluent<?> fluent,WebhookTokenAuthenticator instance) {
    this(fluent, instance, false);
  }
  public WebhookTokenAuthenticatorBuilder(WebhookTokenAuthenticatorFluent<?> fluent,WebhookTokenAuthenticator instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new WebhookTokenAuthenticator());

    if (instance != null) {
      fluent.withKubeConfig(instance.getKubeConfig());
      fluent.withKubeConfig(instance.getKubeConfig());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WebhookTokenAuthenticatorBuilder(WebhookTokenAuthenticator instance) {
    this(instance,false);
  }
  public WebhookTokenAuthenticatorBuilder(WebhookTokenAuthenticator instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new WebhookTokenAuthenticator());

    if (instance != null) {
      this.withKubeConfig(instance.getKubeConfig());
      this.withKubeConfig(instance.getKubeConfig());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  WebhookTokenAuthenticatorFluent<?> fluent;
  Boolean validationEnabled;
  public WebhookTokenAuthenticator build() {
    WebhookTokenAuthenticator buildable = new WebhookTokenAuthenticator(fluent.buildKubeConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}