package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuditBuilder extends AuditFluent<AuditBuilder> implements VisitableBuilder<Audit,AuditBuilder>{
  public AuditBuilder() {
    this(false);
  }
  public AuditBuilder(Boolean validationEnabled) {
    this(new Audit(), validationEnabled);
  }
  public AuditBuilder(AuditFluent<?> fluent) {
    this(fluent, false);
  }
  public AuditBuilder(AuditFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Audit(), validationEnabled);
  }
  public AuditBuilder(AuditFluent<?> fluent,Audit instance) {
    this(fluent, instance, false);
  }
  public AuditBuilder(AuditFluent<?> fluent,Audit instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Audit());

    if (instance != null) {
      fluent.withCustomRules(instance.getCustomRules());
      fluent.withProfile(instance.getProfile());
      fluent.withCustomRules(instance.getCustomRules());
      fluent.withProfile(instance.getProfile());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AuditBuilder(Audit instance) {
    this(instance,false);
  }
  public AuditBuilder(Audit instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Audit());

    if (instance != null) {
      this.withCustomRules(instance.getCustomRules());
      this.withProfile(instance.getProfile());
      this.withCustomRules(instance.getCustomRules());
      this.withProfile(instance.getProfile());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AuditFluent<?> fluent;
  Boolean validationEnabled;
  public Audit build() {
    Audit buildable = new Audit(fluent.buildCustomRules(),fluent.getProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}