package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AzurePlatformStatusBuilder extends AzurePlatformStatusFluent<AzurePlatformStatusBuilder> implements VisitableBuilder<AzurePlatformStatus,AzurePlatformStatusBuilder>{
  public AzurePlatformStatusBuilder() {
    this(false);
  }
  public AzurePlatformStatusBuilder(Boolean validationEnabled) {
    this(new AzurePlatformStatus(), validationEnabled);
  }
  public AzurePlatformStatusBuilder(AzurePlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AzurePlatformStatusBuilder(AzurePlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AzurePlatformStatus(), validationEnabled);
  }
  public AzurePlatformStatusBuilder(AzurePlatformStatusFluent<?> fluent,AzurePlatformStatus instance) {
    this(fluent, instance, false);
  }
  public AzurePlatformStatusBuilder(AzurePlatformStatusFluent<?> fluent,AzurePlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AzurePlatformStatus());

    if (instance != null) {
      fluent.withArmEndpoint(instance.getArmEndpoint());
      fluent.withCloudName(instance.getCloudName());
      fluent.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
      fluent.withResourceGroupName(instance.getResourceGroupName());
      fluent.withResourceTags(instance.getResourceTags());
      fluent.withArmEndpoint(instance.getArmEndpoint());
      fluent.withCloudName(instance.getCloudName());
      fluent.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
      fluent.withResourceGroupName(instance.getResourceGroupName());
      fluent.withResourceTags(instance.getResourceTags());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AzurePlatformStatusBuilder(AzurePlatformStatus instance) {
    this(instance,false);
  }
  public AzurePlatformStatusBuilder(AzurePlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AzurePlatformStatus());

    if (instance != null) {
      this.withArmEndpoint(instance.getArmEndpoint());
      this.withCloudName(instance.getCloudName());
      this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
      this.withResourceGroupName(instance.getResourceGroupName());
      this.withResourceTags(instance.getResourceTags());
      this.withArmEndpoint(instance.getArmEndpoint());
      this.withCloudName(instance.getCloudName());
      this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
      this.withResourceGroupName(instance.getResourceGroupName());
      this.withResourceTags(instance.getResourceTags());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AzurePlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public AzurePlatformStatus build() {
    AzurePlatformStatus buildable = new AzurePlatformStatus(fluent.getArmEndpoint(),fluent.getCloudName(),fluent.getNetworkResourceGroupName(),fluent.getResourceGroupName(),fluent.buildResourceTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}