package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressPlatformSpecBuilder extends IngressPlatformSpecFluent<IngressPlatformSpecBuilder> implements VisitableBuilder<IngressPlatformSpec,IngressPlatformSpecBuilder>{
  public IngressPlatformSpecBuilder() {
    this(false);
  }
  public IngressPlatformSpecBuilder(Boolean validationEnabled) {
    this(new IngressPlatformSpec(), validationEnabled);
  }
  public IngressPlatformSpecBuilder(IngressPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressPlatformSpecBuilder(IngressPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressPlatformSpec(), validationEnabled);
  }
  public IngressPlatformSpecBuilder(IngressPlatformSpecFluent<?> fluent,IngressPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public IngressPlatformSpecBuilder(IngressPlatformSpecFluent<?> fluent,IngressPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IngressPlatformSpec());

    if (instance != null) {
      fluent.withAws(instance.getAws());
      fluent.withType(instance.getType());
      fluent.withAws(instance.getAws());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressPlatformSpecBuilder(IngressPlatformSpec instance) {
    this(instance,false);
  }
  public IngressPlatformSpecBuilder(IngressPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IngressPlatformSpec());

    if (instance != null) {
      this.withAws(instance.getAws());
      this.withType(instance.getType());
      this.withAws(instance.getAws());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public IngressPlatformSpec build() {
    IngressPlatformSpec buildable = new IngressPlatformSpec(fluent.buildAws(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}