package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorHubBuilder extends OperatorHubFluent<OperatorHubBuilder> implements VisitableBuilder<OperatorHub,OperatorHubBuilder>{
  public OperatorHubBuilder() {
    this(false);
  }
  public OperatorHubBuilder(Boolean validationEnabled) {
    this(new OperatorHub(), validationEnabled);
  }
  public OperatorHubBuilder(OperatorHubFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorHubBuilder(OperatorHubFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorHub(), validationEnabled);
  }
  public OperatorHubBuilder(OperatorHubFluent<?> fluent,OperatorHub instance) {
    this(fluent, instance, false);
  }
  public OperatorHubBuilder(OperatorHubFluent<?> fluent,OperatorHub instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OperatorHub());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OperatorHubBuilder(OperatorHub instance) {
    this(instance,false);
  }
  public OperatorHubBuilder(OperatorHub instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OperatorHub());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OperatorHubFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorHub build() {
    OperatorHub buildable = new OperatorHub(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}