package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorHubListBuilder extends OperatorHubListFluent<OperatorHubListBuilder> implements VisitableBuilder<OperatorHubList,OperatorHubListBuilder>{
  public OperatorHubListBuilder() {
    this(false);
  }
  public OperatorHubListBuilder(Boolean validationEnabled) {
    this(new OperatorHubList(), validationEnabled);
  }
  public OperatorHubListBuilder(OperatorHubListFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorHubListBuilder(OperatorHubListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorHubList(), validationEnabled);
  }
  public OperatorHubListBuilder(OperatorHubListFluent<?> fluent,OperatorHubList instance) {
    this(fluent, instance, false);
  }
  public OperatorHubListBuilder(OperatorHubListFluent<?> fluent,OperatorHubList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OperatorHubList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OperatorHubListBuilder(OperatorHubList instance) {
    this(instance,false);
  }
  public OperatorHubListBuilder(OperatorHubList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OperatorHubList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OperatorHubListFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorHubList build() {
    OperatorHubList buildable = new OperatorHubList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}