package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProjectSpecBuilder extends ProjectSpecFluent<ProjectSpecBuilder> implements VisitableBuilder<ProjectSpec,ProjectSpecBuilder>{
  public ProjectSpecBuilder() {
    this(false);
  }
  public ProjectSpecBuilder(Boolean validationEnabled) {
    this(new ProjectSpec(), validationEnabled);
  }
  public ProjectSpecBuilder(ProjectSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ProjectSpecBuilder(ProjectSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProjectSpec(), validationEnabled);
  }
  public ProjectSpecBuilder(ProjectSpecFluent<?> fluent,ProjectSpec instance) {
    this(fluent, instance, false);
  }
  public ProjectSpecBuilder(ProjectSpecFluent<?> fluent,ProjectSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ProjectSpec());

    if (instance != null) {
      fluent.withProjectRequestMessage(instance.getProjectRequestMessage());
      fluent.withProjectRequestTemplate(instance.getProjectRequestTemplate());
      fluent.withProjectRequestMessage(instance.getProjectRequestMessage());
      fluent.withProjectRequestTemplate(instance.getProjectRequestTemplate());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProjectSpecBuilder(ProjectSpec instance) {
    this(instance,false);
  }
  public ProjectSpecBuilder(ProjectSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ProjectSpec());

    if (instance != null) {
      this.withProjectRequestMessage(instance.getProjectRequestMessage());
      this.withProjectRequestTemplate(instance.getProjectRequestTemplate());
      this.withProjectRequestMessage(instance.getProjectRequestMessage());
      this.withProjectRequestTemplate(instance.getProjectRequestTemplate());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProjectSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ProjectSpec build() {
    ProjectSpec buildable = new ProjectSpec(fluent.getProjectRequestMessage(),fluent.buildProjectRequestTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}