package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProjectSpecFluent<A extends ProjectSpecFluent<A>> extends BaseFluent<A>{
  public ProjectSpecFluent() {
  }
  public ProjectSpecFluent(ProjectSpec instance) {
    instance = (instance != null ? instance : new ProjectSpec());

    if (instance != null) {
      this.withProjectRequestMessage(instance.getProjectRequestMessage());
      this.withProjectRequestTemplate(instance.getProjectRequestTemplate());
      this.withProjectRequestMessage(instance.getProjectRequestMessage());
      this.withProjectRequestTemplate(instance.getProjectRequestTemplate());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String projectRequestMessage;
  private TemplateReferenceBuilder projectRequestTemplate;
  private Map<String,Object> additionalProperties;
  public String getProjectRequestMessage() {
    return this.projectRequestMessage;
  }
  public A withProjectRequestMessage(String projectRequestMessage) {
    this.projectRequestMessage=projectRequestMessage; return (A) this;
  }
  public boolean hasProjectRequestMessage() {
    return this.projectRequestMessage != null;
  }
  public TemplateReference buildProjectRequestTemplate() {
    return this.projectRequestTemplate!=null ?this.projectRequestTemplate.build():null;
  }
  public A withProjectRequestTemplate(TemplateReference projectRequestTemplate) {
    _visitables.get("projectRequestTemplate").remove(this.projectRequestTemplate);
    if (projectRequestTemplate!=null){ this.projectRequestTemplate= new TemplateReferenceBuilder(projectRequestTemplate); _visitables.get("projectRequestTemplate").add(this.projectRequestTemplate);} else { this.projectRequestTemplate = null; _visitables.get("projectRequestTemplate").remove(this.projectRequestTemplate); } return (A) this;
  }
  public boolean hasProjectRequestTemplate() {
    return this.projectRequestTemplate != null;
  }
  public A withNewProjectRequestTemplate(String name) {
    return (A)withProjectRequestTemplate(new TemplateReference(name));
  }
  public ProjectRequestTemplateNested<A> withNewProjectRequestTemplate() {
    return new ProjectRequestTemplateNested(null);
  }
  public ProjectRequestTemplateNested<A> withNewProjectRequestTemplateLike(TemplateReference item) {
    return new ProjectRequestTemplateNested(item);
  }
  public ProjectRequestTemplateNested<A> editProjectRequestTemplate() {
    return withNewProjectRequestTemplateLike(java.util.Optional.ofNullable(buildProjectRequestTemplate()).orElse(null));
  }
  public ProjectRequestTemplateNested<A> editOrNewProjectRequestTemplate() {
    return withNewProjectRequestTemplateLike(java.util.Optional.ofNullable(buildProjectRequestTemplate()).orElse(new TemplateReferenceBuilder().build()));
  }
  public ProjectRequestTemplateNested<A> editOrNewProjectRequestTemplateLike(TemplateReference item) {
    return withNewProjectRequestTemplateLike(java.util.Optional.ofNullable(buildProjectRequestTemplate()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProjectSpecFluent that = (ProjectSpecFluent) o;
    if (!java.util.Objects.equals(projectRequestMessage, that.projectRequestMessage)) return false;

    if (!java.util.Objects.equals(projectRequestTemplate, that.projectRequestTemplate)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(projectRequestMessage,  projectRequestTemplate,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (projectRequestMessage != null) { sb.append("projectRequestMessage:"); sb.append(projectRequestMessage + ","); }
    if (projectRequestTemplate != null) { sb.append("projectRequestTemplate:"); sb.append(projectRequestTemplate + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ProjectRequestTemplateNested<N> extends TemplateReferenceFluent<ProjectRequestTemplateNested<N>> implements Nested<N>{
    ProjectRequestTemplateNested(TemplateReference item) {
      this.builder = new TemplateReferenceBuilder(this, item);
    }
    TemplateReferenceBuilder builder;
    public N and() {
      return (N) ProjectSpecFluent.this.withProjectRequestTemplate(builder.build());
    }
    public N endProjectRequestTemplate() {
      return and();
    }
    
  }
  
}