package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AuthenticationStatusFluent<A extends AuthenticationStatusFluent<A>> extends BaseFluent<A>{
  public AuthenticationStatusFluent() {
  }
  
  public AuthenticationStatusFluent(AuthenticationStatus instance) {
    this.copyInstance(instance);
  }
  private ConfigMapNameReferenceBuilder integratedOAuthMetadata;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AuthenticationStatus instance) {
    instance = (instance != null ? instance : new AuthenticationStatus());
  
    if (instance != null) {
        this.withIntegratedOAuthMetadata(instance.getIntegratedOAuthMetadata());
        this.withIntegratedOAuthMetadata(instance.getIntegratedOAuthMetadata());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public ConfigMapNameReference buildIntegratedOAuthMetadata() {
    return this.integratedOAuthMetadata!=null ?this.integratedOAuthMetadata.build():null;
  }
  
  public A withIntegratedOAuthMetadata(ConfigMapNameReference integratedOAuthMetadata) {
    _visitables.get("integratedOAuthMetadata").remove(this.integratedOAuthMetadata);
    if (integratedOAuthMetadata!=null){ this.integratedOAuthMetadata= new ConfigMapNameReferenceBuilder(integratedOAuthMetadata); _visitables.get("integratedOAuthMetadata").add(this.integratedOAuthMetadata);} else { this.integratedOAuthMetadata = null; _visitables.get("integratedOAuthMetadata").remove(this.integratedOAuthMetadata); } return (A) this;
  }
  
  public boolean hasIntegratedOAuthMetadata() {
    return this.integratedOAuthMetadata != null;
  }
  
  public A withNewIntegratedOAuthMetadata(String name) {
    return (A)withIntegratedOAuthMetadata(new ConfigMapNameReference(name));
  }
  
  public IntegratedOAuthMetadataNested<A> withNewIntegratedOAuthMetadata() {
    return new IntegratedOAuthMetadataNested(null);
  }
  
  public IntegratedOAuthMetadataNested<A> withNewIntegratedOAuthMetadataLike(ConfigMapNameReference item) {
    return new IntegratedOAuthMetadataNested(item);
  }
  
  public IntegratedOAuthMetadataNested<A> editIntegratedOAuthMetadata() {
    return withNewIntegratedOAuthMetadataLike(java.util.Optional.ofNullable(buildIntegratedOAuthMetadata()).orElse(null));
  }
  
  public IntegratedOAuthMetadataNested<A> editOrNewIntegratedOAuthMetadata() {
    return withNewIntegratedOAuthMetadataLike(java.util.Optional.ofNullable(buildIntegratedOAuthMetadata()).orElse(new ConfigMapNameReferenceBuilder().build()));
  }
  
  public IntegratedOAuthMetadataNested<A> editOrNewIntegratedOAuthMetadataLike(ConfigMapNameReference item) {
    return withNewIntegratedOAuthMetadataLike(java.util.Optional.ofNullable(buildIntegratedOAuthMetadata()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AuthenticationStatusFluent that = (AuthenticationStatusFluent) o;
    if (!java.util.Objects.equals(integratedOAuthMetadata, that.integratedOAuthMetadata)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(integratedOAuthMetadata,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (integratedOAuthMetadata != null) { sb.append("integratedOAuthMetadata:"); sb.append(integratedOAuthMetadata + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class IntegratedOAuthMetadataNested<N> extends ConfigMapNameReferenceFluent<IntegratedOAuthMetadataNested<N>> implements Nested<N>{
    IntegratedOAuthMetadataNested(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    ConfigMapNameReferenceBuilder builder;
    
    public N and() {
      return (N) AuthenticationStatusFluent.this.withIntegratedOAuthMetadata(builder.build());
    }
    
    public N endIntegratedOAuthMetadata() {
      return and();
    }
    
  
  }

}