package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ComponentRouteSpecFluent<A extends ComponentRouteSpecFluent<A>> extends BaseFluent<A>{
  public ComponentRouteSpecFluent() {
  }
  
  public ComponentRouteSpecFluent(ComponentRouteSpec instance) {
    this.copyInstance(instance);
  }
  private String hostname;
  private String name;
  private String namespace;
  private SecretNameReferenceBuilder servingCertKeyPairSecret;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ComponentRouteSpec instance) {
    instance = (instance != null ? instance : new ComponentRouteSpec());
  
    if (instance != null) {
        this.withHostname(instance.getHostname());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withServingCertKeyPairSecret(instance.getServingCertKeyPairSecret());
        this.withHostname(instance.getHostname());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withServingCertKeyPairSecret(instance.getServingCertKeyPairSecret());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getHostname() {
    return this.hostname;
  }
  
  public A withHostname(String hostname) {
    this.hostname=hostname; return (A) this;
  }
  
  public boolean hasHostname() {
    return this.hostname != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public SecretNameReference buildServingCertKeyPairSecret() {
    return this.servingCertKeyPairSecret!=null ?this.servingCertKeyPairSecret.build():null;
  }
  
  public A withServingCertKeyPairSecret(SecretNameReference servingCertKeyPairSecret) {
    _visitables.get("servingCertKeyPairSecret").remove(this.servingCertKeyPairSecret);
    if (servingCertKeyPairSecret!=null){ this.servingCertKeyPairSecret= new SecretNameReferenceBuilder(servingCertKeyPairSecret); _visitables.get("servingCertKeyPairSecret").add(this.servingCertKeyPairSecret);} else { this.servingCertKeyPairSecret = null; _visitables.get("servingCertKeyPairSecret").remove(this.servingCertKeyPairSecret); } return (A) this;
  }
  
  public boolean hasServingCertKeyPairSecret() {
    return this.servingCertKeyPairSecret != null;
  }
  
  public A withNewServingCertKeyPairSecret(String name) {
    return (A)withServingCertKeyPairSecret(new SecretNameReference(name));
  }
  
  public ServingCertKeyPairSecretNested<A> withNewServingCertKeyPairSecret() {
    return new ServingCertKeyPairSecretNested(null);
  }
  
  public ServingCertKeyPairSecretNested<A> withNewServingCertKeyPairSecretLike(SecretNameReference item) {
    return new ServingCertKeyPairSecretNested(item);
  }
  
  public ServingCertKeyPairSecretNested<A> editServingCertKeyPairSecret() {
    return withNewServingCertKeyPairSecretLike(java.util.Optional.ofNullable(buildServingCertKeyPairSecret()).orElse(null));
  }
  
  public ServingCertKeyPairSecretNested<A> editOrNewServingCertKeyPairSecret() {
    return withNewServingCertKeyPairSecretLike(java.util.Optional.ofNullable(buildServingCertKeyPairSecret()).orElse(new SecretNameReferenceBuilder().build()));
  }
  
  public ServingCertKeyPairSecretNested<A> editOrNewServingCertKeyPairSecretLike(SecretNameReference item) {
    return withNewServingCertKeyPairSecretLike(java.util.Optional.ofNullable(buildServingCertKeyPairSecret()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ComponentRouteSpecFluent that = (ComponentRouteSpecFluent) o;
    if (!java.util.Objects.equals(hostname, that.hostname)) return false;
  
    if (!java.util.Objects.equals(name, that.name)) return false;
  
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
  
    if (!java.util.Objects.equals(servingCertKeyPairSecret, that.servingCertKeyPairSecret)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(hostname,  name,  namespace,  servingCertKeyPairSecret,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hostname != null) { sb.append("hostname:"); sb.append(hostname + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (servingCertKeyPairSecret != null) { sb.append("servingCertKeyPairSecret:"); sb.append(servingCertKeyPairSecret + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ServingCertKeyPairSecretNested<N> extends SecretNameReferenceFluent<ServingCertKeyPairSecretNested<N>> implements Nested<N>{
    ServingCertKeyPairSecretNested(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    SecretNameReferenceBuilder builder;
    
    public N and() {
      return (N) ComponentRouteSpecFluent.this.withServingCertKeyPairSecret(builder.build());
    }
    
    public N endServingCertKeyPairSecret() {
      return and();
    }
    
  
  }

}