package io.fabric8.openshift.api.model.config.v1;

import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlatformSpecFluent<A extends PlatformSpecFluent<A>> extends BaseFluent<A>{
  public PlatformSpecFluent() {
  }
  
  public PlatformSpecFluent(PlatformSpec instance) {
    this.copyInstance(instance);
  }
  private AlibabaCloudPlatformSpecBuilder alibabaCloud;
  private AWSPlatformSpecBuilder aws;
  private AzurePlatformSpecBuilder azure;
  private BareMetalPlatformSpecBuilder baremetal;
  private EquinixMetalPlatformSpecBuilder equinixMetal;
  private ExternalPlatformSpecBuilder external;
  private GCPPlatformSpecBuilder gcp;
  private IBMCloudPlatformSpecBuilder ibmcloud;
  private KubevirtPlatformSpecBuilder kubevirt;
  private NutanixPlatformSpecBuilder nutanix;
  private OpenStackPlatformSpecBuilder openstack;
  private OvirtPlatformSpecBuilder ovirt;
  private PowerVSPlatformSpecBuilder powervs;
  private String type;
  private VSpherePlatformSpecBuilder vsphere;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PlatformSpec instance) {
    instance = (instance != null ? instance : new PlatformSpec());
  
    if (instance != null) {
        this.withAlibabaCloud(instance.getAlibabaCloud());
        this.withAws(instance.getAws());
        this.withAzure(instance.getAzure());
        this.withBaremetal(instance.getBaremetal());
        this.withEquinixMetal(instance.getEquinixMetal());
        this.withExternal(instance.getExternal());
        this.withGcp(instance.getGcp());
        this.withIbmcloud(instance.getIbmcloud());
        this.withKubevirt(instance.getKubevirt());
        this.withNutanix(instance.getNutanix());
        this.withOpenstack(instance.getOpenstack());
        this.withOvirt(instance.getOvirt());
        this.withPowervs(instance.getPowervs());
        this.withType(instance.getType());
        this.withVsphere(instance.getVsphere());
        this.withAlibabaCloud(instance.getAlibabaCloud());
        this.withAws(instance.getAws());
        this.withAzure(instance.getAzure());
        this.withBaremetal(instance.getBaremetal());
        this.withEquinixMetal(instance.getEquinixMetal());
        this.withExternal(instance.getExternal());
        this.withGcp(instance.getGcp());
        this.withIbmcloud(instance.getIbmcloud());
        this.withKubevirt(instance.getKubevirt());
        this.withNutanix(instance.getNutanix());
        this.withOpenstack(instance.getOpenstack());
        this.withOvirt(instance.getOvirt());
        this.withPowervs(instance.getPowervs());
        this.withType(instance.getType());
        this.withVsphere(instance.getVsphere());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public AlibabaCloudPlatformSpec buildAlibabaCloud() {
    return this.alibabaCloud!=null ?this.alibabaCloud.build():null;
  }
  
  public A withAlibabaCloud(AlibabaCloudPlatformSpec alibabaCloud) {
    _visitables.get("alibabaCloud").remove(this.alibabaCloud);
    if (alibabaCloud!=null){ this.alibabaCloud= new AlibabaCloudPlatformSpecBuilder(alibabaCloud); _visitables.get("alibabaCloud").add(this.alibabaCloud);} else { this.alibabaCloud = null; _visitables.get("alibabaCloud").remove(this.alibabaCloud); } return (A) this;
  }
  
  public boolean hasAlibabaCloud() {
    return this.alibabaCloud != null;
  }
  
  public AlibabaCloudNested<A> withNewAlibabaCloud() {
    return new AlibabaCloudNested(null);
  }
  
  public AlibabaCloudNested<A> withNewAlibabaCloudLike(AlibabaCloudPlatformSpec item) {
    return new AlibabaCloudNested(item);
  }
  
  public AlibabaCloudNested<A> editAlibabaCloud() {
    return withNewAlibabaCloudLike(java.util.Optional.ofNullable(buildAlibabaCloud()).orElse(null));
  }
  
  public AlibabaCloudNested<A> editOrNewAlibabaCloud() {
    return withNewAlibabaCloudLike(java.util.Optional.ofNullable(buildAlibabaCloud()).orElse(new AlibabaCloudPlatformSpecBuilder().build()));
  }
  
  public AlibabaCloudNested<A> editOrNewAlibabaCloudLike(AlibabaCloudPlatformSpec item) {
    return withNewAlibabaCloudLike(java.util.Optional.ofNullable(buildAlibabaCloud()).orElse(item));
  }
  
  public AWSPlatformSpec buildAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  
  public A withAws(AWSPlatformSpec aws) {
    _visitables.get("aws").remove(this.aws);
    if (aws!=null){ this.aws= new AWSPlatformSpecBuilder(aws); _visitables.get("aws").add(this.aws);} else { this.aws = null; _visitables.get("aws").remove(this.aws); } return (A) this;
  }
  
  public boolean hasAws() {
    return this.aws != null;
  }
  
  public AwsNested<A> withNewAws() {
    return new AwsNested(null);
  }
  
  public AwsNested<A> withNewAwsLike(AWSPlatformSpec item) {
    return new AwsNested(item);
  }
  
  public AwsNested<A> editAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(null));
  }
  
  public AwsNested<A> editOrNewAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(new AWSPlatformSpecBuilder().build()));
  }
  
  public AwsNested<A> editOrNewAwsLike(AWSPlatformSpec item) {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(item));
  }
  
  public AzurePlatformSpec buildAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  
  public A withAzure(AzurePlatformSpec azure) {
    _visitables.get("azure").remove(this.azure);
    if (azure!=null){ this.azure= new AzurePlatformSpecBuilder(azure); _visitables.get("azure").add(this.azure);} else { this.azure = null; _visitables.get("azure").remove(this.azure); } return (A) this;
  }
  
  public boolean hasAzure() {
    return this.azure != null;
  }
  
  public AzureNested<A> withNewAzure() {
    return new AzureNested(null);
  }
  
  public AzureNested<A> withNewAzureLike(AzurePlatformSpec item) {
    return new AzureNested(item);
  }
  
  public AzureNested<A> editAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(null));
  }
  
  public AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(new AzurePlatformSpecBuilder().build()));
  }
  
  public AzureNested<A> editOrNewAzureLike(AzurePlatformSpec item) {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(item));
  }
  
  public BareMetalPlatformSpec buildBaremetal() {
    return this.baremetal!=null ?this.baremetal.build():null;
  }
  
  public A withBaremetal(BareMetalPlatformSpec baremetal) {
    _visitables.get("baremetal").remove(this.baremetal);
    if (baremetal!=null){ this.baremetal= new BareMetalPlatformSpecBuilder(baremetal); _visitables.get("baremetal").add(this.baremetal);} else { this.baremetal = null; _visitables.get("baremetal").remove(this.baremetal); } return (A) this;
  }
  
  public boolean hasBaremetal() {
    return this.baremetal != null;
  }
  
  public BaremetalNested<A> withNewBaremetal() {
    return new BaremetalNested(null);
  }
  
  public BaremetalNested<A> withNewBaremetalLike(BareMetalPlatformSpec item) {
    return new BaremetalNested(item);
  }
  
  public BaremetalNested<A> editBaremetal() {
    return withNewBaremetalLike(java.util.Optional.ofNullable(buildBaremetal()).orElse(null));
  }
  
  public BaremetalNested<A> editOrNewBaremetal() {
    return withNewBaremetalLike(java.util.Optional.ofNullable(buildBaremetal()).orElse(new BareMetalPlatformSpecBuilder().build()));
  }
  
  public BaremetalNested<A> editOrNewBaremetalLike(BareMetalPlatformSpec item) {
    return withNewBaremetalLike(java.util.Optional.ofNullable(buildBaremetal()).orElse(item));
  }
  
  public EquinixMetalPlatformSpec buildEquinixMetal() {
    return this.equinixMetal!=null ?this.equinixMetal.build():null;
  }
  
  public A withEquinixMetal(EquinixMetalPlatformSpec equinixMetal) {
    _visitables.get("equinixMetal").remove(this.equinixMetal);
    if (equinixMetal!=null){ this.equinixMetal= new EquinixMetalPlatformSpecBuilder(equinixMetal); _visitables.get("equinixMetal").add(this.equinixMetal);} else { this.equinixMetal = null; _visitables.get("equinixMetal").remove(this.equinixMetal); } return (A) this;
  }
  
  public boolean hasEquinixMetal() {
    return this.equinixMetal != null;
  }
  
  public EquinixMetalNested<A> withNewEquinixMetal() {
    return new EquinixMetalNested(null);
  }
  
  public EquinixMetalNested<A> withNewEquinixMetalLike(EquinixMetalPlatformSpec item) {
    return new EquinixMetalNested(item);
  }
  
  public EquinixMetalNested<A> editEquinixMetal() {
    return withNewEquinixMetalLike(java.util.Optional.ofNullable(buildEquinixMetal()).orElse(null));
  }
  
  public EquinixMetalNested<A> editOrNewEquinixMetal() {
    return withNewEquinixMetalLike(java.util.Optional.ofNullable(buildEquinixMetal()).orElse(new EquinixMetalPlatformSpecBuilder().build()));
  }
  
  public EquinixMetalNested<A> editOrNewEquinixMetalLike(EquinixMetalPlatformSpec item) {
    return withNewEquinixMetalLike(java.util.Optional.ofNullable(buildEquinixMetal()).orElse(item));
  }
  
  public ExternalPlatformSpec buildExternal() {
    return this.external!=null ?this.external.build():null;
  }
  
  public A withExternal(ExternalPlatformSpec external) {
    _visitables.get("external").remove(this.external);
    if (external!=null){ this.external= new ExternalPlatformSpecBuilder(external); _visitables.get("external").add(this.external);} else { this.external = null; _visitables.get("external").remove(this.external); } return (A) this;
  }
  
  public boolean hasExternal() {
    return this.external != null;
  }
  
  public A withNewExternal(String platformName) {
    return (A)withExternal(new ExternalPlatformSpec(platformName));
  }
  
  public ExternalNested<A> withNewExternal() {
    return new ExternalNested(null);
  }
  
  public ExternalNested<A> withNewExternalLike(ExternalPlatformSpec item) {
    return new ExternalNested(item);
  }
  
  public ExternalNested<A> editExternal() {
    return withNewExternalLike(java.util.Optional.ofNullable(buildExternal()).orElse(null));
  }
  
  public ExternalNested<A> editOrNewExternal() {
    return withNewExternalLike(java.util.Optional.ofNullable(buildExternal()).orElse(new ExternalPlatformSpecBuilder().build()));
  }
  
  public ExternalNested<A> editOrNewExternalLike(ExternalPlatformSpec item) {
    return withNewExternalLike(java.util.Optional.ofNullable(buildExternal()).orElse(item));
  }
  
  public GCPPlatformSpec buildGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  
  public A withGcp(GCPPlatformSpec gcp) {
    _visitables.get("gcp").remove(this.gcp);
    if (gcp!=null){ this.gcp= new GCPPlatformSpecBuilder(gcp); _visitables.get("gcp").add(this.gcp);} else { this.gcp = null; _visitables.get("gcp").remove(this.gcp); } return (A) this;
  }
  
  public boolean hasGcp() {
    return this.gcp != null;
  }
  
  public GcpNested<A> withNewGcp() {
    return new GcpNested(null);
  }
  
  public GcpNested<A> withNewGcpLike(GCPPlatformSpec item) {
    return new GcpNested(item);
  }
  
  public GcpNested<A> editGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(null));
  }
  
  public GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(new GCPPlatformSpecBuilder().build()));
  }
  
  public GcpNested<A> editOrNewGcpLike(GCPPlatformSpec item) {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(item));
  }
  
  public IBMCloudPlatformSpec buildIbmcloud() {
    return this.ibmcloud!=null ?this.ibmcloud.build():null;
  }
  
  public A withIbmcloud(IBMCloudPlatformSpec ibmcloud) {
    _visitables.get("ibmcloud").remove(this.ibmcloud);
    if (ibmcloud!=null){ this.ibmcloud= new IBMCloudPlatformSpecBuilder(ibmcloud); _visitables.get("ibmcloud").add(this.ibmcloud);} else { this.ibmcloud = null; _visitables.get("ibmcloud").remove(this.ibmcloud); } return (A) this;
  }
  
  public boolean hasIbmcloud() {
    return this.ibmcloud != null;
  }
  
  public IbmcloudNested<A> withNewIbmcloud() {
    return new IbmcloudNested(null);
  }
  
  public IbmcloudNested<A> withNewIbmcloudLike(IBMCloudPlatformSpec item) {
    return new IbmcloudNested(item);
  }
  
  public IbmcloudNested<A> editIbmcloud() {
    return withNewIbmcloudLike(java.util.Optional.ofNullable(buildIbmcloud()).orElse(null));
  }
  
  public IbmcloudNested<A> editOrNewIbmcloud() {
    return withNewIbmcloudLike(java.util.Optional.ofNullable(buildIbmcloud()).orElse(new IBMCloudPlatformSpecBuilder().build()));
  }
  
  public IbmcloudNested<A> editOrNewIbmcloudLike(IBMCloudPlatformSpec item) {
    return withNewIbmcloudLike(java.util.Optional.ofNullable(buildIbmcloud()).orElse(item));
  }
  
  public KubevirtPlatformSpec buildKubevirt() {
    return this.kubevirt!=null ?this.kubevirt.build():null;
  }
  
  public A withKubevirt(KubevirtPlatformSpec kubevirt) {
    _visitables.get("kubevirt").remove(this.kubevirt);
    if (kubevirt!=null){ this.kubevirt= new KubevirtPlatformSpecBuilder(kubevirt); _visitables.get("kubevirt").add(this.kubevirt);} else { this.kubevirt = null; _visitables.get("kubevirt").remove(this.kubevirt); } return (A) this;
  }
  
  public boolean hasKubevirt() {
    return this.kubevirt != null;
  }
  
  public KubevirtNested<A> withNewKubevirt() {
    return new KubevirtNested(null);
  }
  
  public KubevirtNested<A> withNewKubevirtLike(KubevirtPlatformSpec item) {
    return new KubevirtNested(item);
  }
  
  public KubevirtNested<A> editKubevirt() {
    return withNewKubevirtLike(java.util.Optional.ofNullable(buildKubevirt()).orElse(null));
  }
  
  public KubevirtNested<A> editOrNewKubevirt() {
    return withNewKubevirtLike(java.util.Optional.ofNullable(buildKubevirt()).orElse(new KubevirtPlatformSpecBuilder().build()));
  }
  
  public KubevirtNested<A> editOrNewKubevirtLike(KubevirtPlatformSpec item) {
    return withNewKubevirtLike(java.util.Optional.ofNullable(buildKubevirt()).orElse(item));
  }
  
  public NutanixPlatformSpec buildNutanix() {
    return this.nutanix!=null ?this.nutanix.build():null;
  }
  
  public A withNutanix(NutanixPlatformSpec nutanix) {
    _visitables.get("nutanix").remove(this.nutanix);
    if (nutanix!=null){ this.nutanix= new NutanixPlatformSpecBuilder(nutanix); _visitables.get("nutanix").add(this.nutanix);} else { this.nutanix = null; _visitables.get("nutanix").remove(this.nutanix); } return (A) this;
  }
  
  public boolean hasNutanix() {
    return this.nutanix != null;
  }
  
  public NutanixNested<A> withNewNutanix() {
    return new NutanixNested(null);
  }
  
  public NutanixNested<A> withNewNutanixLike(NutanixPlatformSpec item) {
    return new NutanixNested(item);
  }
  
  public NutanixNested<A> editNutanix() {
    return withNewNutanixLike(java.util.Optional.ofNullable(buildNutanix()).orElse(null));
  }
  
  public NutanixNested<A> editOrNewNutanix() {
    return withNewNutanixLike(java.util.Optional.ofNullable(buildNutanix()).orElse(new NutanixPlatformSpecBuilder().build()));
  }
  
  public NutanixNested<A> editOrNewNutanixLike(NutanixPlatformSpec item) {
    return withNewNutanixLike(java.util.Optional.ofNullable(buildNutanix()).orElse(item));
  }
  
  public OpenStackPlatformSpec buildOpenstack() {
    return this.openstack!=null ?this.openstack.build():null;
  }
  
  public A withOpenstack(OpenStackPlatformSpec openstack) {
    _visitables.get("openstack").remove(this.openstack);
    if (openstack!=null){ this.openstack= new OpenStackPlatformSpecBuilder(openstack); _visitables.get("openstack").add(this.openstack);} else { this.openstack = null; _visitables.get("openstack").remove(this.openstack); } return (A) this;
  }
  
  public boolean hasOpenstack() {
    return this.openstack != null;
  }
  
  public OpenstackNested<A> withNewOpenstack() {
    return new OpenstackNested(null);
  }
  
  public OpenstackNested<A> withNewOpenstackLike(OpenStackPlatformSpec item) {
    return new OpenstackNested(item);
  }
  
  public OpenstackNested<A> editOpenstack() {
    return withNewOpenstackLike(java.util.Optional.ofNullable(buildOpenstack()).orElse(null));
  }
  
  public OpenstackNested<A> editOrNewOpenstack() {
    return withNewOpenstackLike(java.util.Optional.ofNullable(buildOpenstack()).orElse(new OpenStackPlatformSpecBuilder().build()));
  }
  
  public OpenstackNested<A> editOrNewOpenstackLike(OpenStackPlatformSpec item) {
    return withNewOpenstackLike(java.util.Optional.ofNullable(buildOpenstack()).orElse(item));
  }
  
  public OvirtPlatformSpec buildOvirt() {
    return this.ovirt!=null ?this.ovirt.build():null;
  }
  
  public A withOvirt(OvirtPlatformSpec ovirt) {
    _visitables.get("ovirt").remove(this.ovirt);
    if (ovirt!=null){ this.ovirt= new OvirtPlatformSpecBuilder(ovirt); _visitables.get("ovirt").add(this.ovirt);} else { this.ovirt = null; _visitables.get("ovirt").remove(this.ovirt); } return (A) this;
  }
  
  public boolean hasOvirt() {
    return this.ovirt != null;
  }
  
  public OvirtNested<A> withNewOvirt() {
    return new OvirtNested(null);
  }
  
  public OvirtNested<A> withNewOvirtLike(OvirtPlatformSpec item) {
    return new OvirtNested(item);
  }
  
  public OvirtNested<A> editOvirt() {
    return withNewOvirtLike(java.util.Optional.ofNullable(buildOvirt()).orElse(null));
  }
  
  public OvirtNested<A> editOrNewOvirt() {
    return withNewOvirtLike(java.util.Optional.ofNullable(buildOvirt()).orElse(new OvirtPlatformSpecBuilder().build()));
  }
  
  public OvirtNested<A> editOrNewOvirtLike(OvirtPlatformSpec item) {
    return withNewOvirtLike(java.util.Optional.ofNullable(buildOvirt()).orElse(item));
  }
  
  public PowerVSPlatformSpec buildPowervs() {
    return this.powervs!=null ?this.powervs.build():null;
  }
  
  public A withPowervs(PowerVSPlatformSpec powervs) {
    _visitables.get("powervs").remove(this.powervs);
    if (powervs!=null){ this.powervs= new PowerVSPlatformSpecBuilder(powervs); _visitables.get("powervs").add(this.powervs);} else { this.powervs = null; _visitables.get("powervs").remove(this.powervs); } return (A) this;
  }
  
  public boolean hasPowervs() {
    return this.powervs != null;
  }
  
  public PowervsNested<A> withNewPowervs() {
    return new PowervsNested(null);
  }
  
  public PowervsNested<A> withNewPowervsLike(PowerVSPlatformSpec item) {
    return new PowervsNested(item);
  }
  
  public PowervsNested<A> editPowervs() {
    return withNewPowervsLike(java.util.Optional.ofNullable(buildPowervs()).orElse(null));
  }
  
  public PowervsNested<A> editOrNewPowervs() {
    return withNewPowervsLike(java.util.Optional.ofNullable(buildPowervs()).orElse(new PowerVSPlatformSpecBuilder().build()));
  }
  
  public PowervsNested<A> editOrNewPowervsLike(PowerVSPlatformSpec item) {
    return withNewPowervsLike(java.util.Optional.ofNullable(buildPowervs()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public VSpherePlatformSpec buildVsphere() {
    return this.vsphere!=null ?this.vsphere.build():null;
  }
  
  public A withVsphere(VSpherePlatformSpec vsphere) {
    _visitables.get("vsphere").remove(this.vsphere);
    if (vsphere!=null){ this.vsphere= new VSpherePlatformSpecBuilder(vsphere); _visitables.get("vsphere").add(this.vsphere);} else { this.vsphere = null; _visitables.get("vsphere").remove(this.vsphere); } return (A) this;
  }
  
  public boolean hasVsphere() {
    return this.vsphere != null;
  }
  
  public VsphereNested<A> withNewVsphere() {
    return new VsphereNested(null);
  }
  
  public VsphereNested<A> withNewVsphereLike(VSpherePlatformSpec item) {
    return new VsphereNested(item);
  }
  
  public VsphereNested<A> editVsphere() {
    return withNewVsphereLike(java.util.Optional.ofNullable(buildVsphere()).orElse(null));
  }
  
  public VsphereNested<A> editOrNewVsphere() {
    return withNewVsphereLike(java.util.Optional.ofNullable(buildVsphere()).orElse(new VSpherePlatformSpecBuilder().build()));
  }
  
  public VsphereNested<A> editOrNewVsphereLike(VSpherePlatformSpec item) {
    return withNewVsphereLike(java.util.Optional.ofNullable(buildVsphere()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformSpecFluent that = (PlatformSpecFluent) o;
    if (!java.util.Objects.equals(alibabaCloud, that.alibabaCloud)) return false;
  
    if (!java.util.Objects.equals(aws, that.aws)) return false;
  
    if (!java.util.Objects.equals(azure, that.azure)) return false;
  
    if (!java.util.Objects.equals(baremetal, that.baremetal)) return false;
  
    if (!java.util.Objects.equals(equinixMetal, that.equinixMetal)) return false;
  
    if (!java.util.Objects.equals(external, that.external)) return false;
  
    if (!java.util.Objects.equals(gcp, that.gcp)) return false;
  
    if (!java.util.Objects.equals(ibmcloud, that.ibmcloud)) return false;
  
    if (!java.util.Objects.equals(kubevirt, that.kubevirt)) return false;
  
    if (!java.util.Objects.equals(nutanix, that.nutanix)) return false;
  
    if (!java.util.Objects.equals(openstack, that.openstack)) return false;
  
    if (!java.util.Objects.equals(ovirt, that.ovirt)) return false;
  
    if (!java.util.Objects.equals(powervs, that.powervs)) return false;
  
    if (!java.util.Objects.equals(type, that.type)) return false;
  
    if (!java.util.Objects.equals(vsphere, that.vsphere)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(alibabaCloud,  aws,  azure,  baremetal,  equinixMetal,  external,  gcp,  ibmcloud,  kubevirt,  nutanix,  openstack,  ovirt,  powervs,  type,  vsphere,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (alibabaCloud != null) { sb.append("alibabaCloud:"); sb.append(alibabaCloud + ","); }
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (baremetal != null) { sb.append("baremetal:"); sb.append(baremetal + ","); }
    if (equinixMetal != null) { sb.append("equinixMetal:"); sb.append(equinixMetal + ","); }
    if (external != null) { sb.append("external:"); sb.append(external + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (ibmcloud != null) { sb.append("ibmcloud:"); sb.append(ibmcloud + ","); }
    if (kubevirt != null) { sb.append("kubevirt:"); sb.append(kubevirt + ","); }
    if (nutanix != null) { sb.append("nutanix:"); sb.append(nutanix + ","); }
    if (openstack != null) { sb.append("openstack:"); sb.append(openstack + ","); }
    if (ovirt != null) { sb.append("ovirt:"); sb.append(ovirt + ","); }
    if (powervs != null) { sb.append("powervs:"); sb.append(powervs + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (vsphere != null) { sb.append("vsphere:"); sb.append(vsphere + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AlibabaCloudNested<N> extends AlibabaCloudPlatformSpecFluent<AlibabaCloudNested<N>> implements Nested<N>{
    AlibabaCloudNested(AlibabaCloudPlatformSpec item) {
      this.builder = new AlibabaCloudPlatformSpecBuilder(this, item);
    }
    AlibabaCloudPlatformSpecBuilder builder;
    
    public N and() {
      return (N) PlatformSpecFluent.this.withAlibabaCloud(builder.build());
    }
    
    public N endAlibabaCloud() {
      return and();
    }
    
  
  }
  public class AwsNested<N> extends AWSPlatformSpecFluent<AwsNested<N>> implements Nested<N>{
    AwsNested(AWSPlatformSpec item) {
      this.builder = new AWSPlatformSpecBuilder(this, item);
    }
    AWSPlatformSpecBuilder builder;
    
    public N and() {
      return (N) PlatformSpecFluent.this.withAws(builder.build());
    }
    
    public N endAws() {
      return and();
    }
    
  
  }
  public class AzureNested<N> extends AzurePlatformSpecFluent<AzureNested<N>> implements Nested<N>{
    AzureNested(AzurePlatformSpec item) {
      this.builder = new AzurePlatformSpecBuilder(this, item);
    }
    AzurePlatformSpecBuilder builder;
    
    public N and() {
      return (N) PlatformSpecFluent.this.withAzure(builder.build());
    }
    
    public N endAzure() {
      return and();
    }
    
  
  }
  public class BaremetalNested<N> extends BareMetalPlatformSpecFluent<BaremetalNested<N>> implements Nested<N>{
    BaremetalNested(BareMetalPlatformSpec item) {
      this.builder = new BareMetalPlatformSpecBuilder(this, item);
    }
    BareMetalPlatformSpecBuilder builder;
    
    public N and() {
      return (N) PlatformSpecFluent.this.withBaremetal(builder.build());
    }
    
    public N endBaremetal() {
      return and();
    }
    
  
  }
  public class EquinixMetalNested<N> extends EquinixMetalPlatformSpecFluent<EquinixMetalNested<N>> implements Nested<N>{
    EquinixMetalNested(EquinixMetalPlatformSpec item) {
      this.builder = new EquinixMetalPlatformSpecBuilder(this, item);
    }
    EquinixMetalPlatformSpecBuilder builder;
    
    public N and() {
      return (N) PlatformSpecFluent.this.withEquinixMetal(builder.build());
    }
    
    public N endEquinixMetal() {
      return and();
    }
    
  
  }
  public class ExternalNested<N> extends ExternalPlatformSpecFluent<ExternalNested<N>> implements Nested<N>{
    ExternalNested(ExternalPlatformSpec item) {
      this.builder = new ExternalPlatformSpecBuilder(this, item);
    }
    ExternalPlatformSpecBuilder builder;
    
    public N and() {
      return (N) PlatformSpecFluent.this.withExternal(builder.build());
    }
    
    public N endExternal() {
      return and();
    }
    
  
  }
  public class GcpNested<N> extends GCPPlatformSpecFluent<GcpNested<N>> implements Nested<N>{
    GcpNested(GCPPlatformSpec item) {
      this.builder = new GCPPlatformSpecBuilder(this, item);
    }
    GCPPlatformSpecBuilder builder;
    
    public N and() {
      return (N) PlatformSpecFluent.this.withGcp(builder.build());
    }
    
    public N endGcp() {
      return and();
    }
    
  
  }
  public class IbmcloudNested<N> extends IBMCloudPlatformSpecFluent<IbmcloudNested<N>> implements Nested<N>{
    IbmcloudNested(IBMCloudPlatformSpec item) {
      this.builder = new IBMCloudPlatformSpecBuilder(this, item);
    }
    IBMCloudPlatformSpecBuilder builder;
    
    public N and() {
      return (N) PlatformSpecFluent.this.withIbmcloud(builder.build());
    }
    
    public N endIbmcloud() {
      return and();
    }
    
  
  }
  public class KubevirtNested<N> extends KubevirtPlatformSpecFluent<KubevirtNested<N>> implements Nested<N>{
    KubevirtNested(KubevirtPlatformSpec item) {
      this.builder = new KubevirtPlatformSpecBuilder(this, item);
    }
    KubevirtPlatformSpecBuilder builder;
    
    public N and() {
      return (N) PlatformSpecFluent.this.withKubevirt(builder.build());
    }
    
    public N endKubevirt() {
      return and();
    }
    
  
  }
  public class NutanixNested<N> extends NutanixPlatformSpecFluent<NutanixNested<N>> implements Nested<N>{
    NutanixNested(NutanixPlatformSpec item) {
      this.builder = new NutanixPlatformSpecBuilder(this, item);
    }
    NutanixPlatformSpecBuilder builder;
    
    public N and() {
      return (N) PlatformSpecFluent.this.withNutanix(builder.build());
    }
    
    public N endNutanix() {
      return and();
    }
    
  
  }
  public class OpenstackNested<N> extends OpenStackPlatformSpecFluent<OpenstackNested<N>> implements Nested<N>{
    OpenstackNested(OpenStackPlatformSpec item) {
      this.builder = new OpenStackPlatformSpecBuilder(this, item);
    }
    OpenStackPlatformSpecBuilder builder;
    
    public N and() {
      return (N) PlatformSpecFluent.this.withOpenstack(builder.build());
    }
    
    public N endOpenstack() {
      return and();
    }
    
  
  }
  public class OvirtNested<N> extends OvirtPlatformSpecFluent<OvirtNested<N>> implements Nested<N>{
    OvirtNested(OvirtPlatformSpec item) {
      this.builder = new OvirtPlatformSpecBuilder(this, item);
    }
    OvirtPlatformSpecBuilder builder;
    
    public N and() {
      return (N) PlatformSpecFluent.this.withOvirt(builder.build());
    }
    
    public N endOvirt() {
      return and();
    }
    
  
  }
  public class PowervsNested<N> extends PowerVSPlatformSpecFluent<PowervsNested<N>> implements Nested<N>{
    PowervsNested(PowerVSPlatformSpec item) {
      this.builder = new PowerVSPlatformSpecBuilder(this, item);
    }
    PowerVSPlatformSpecBuilder builder;
    
    public N and() {
      return (N) PlatformSpecFluent.this.withPowervs(builder.build());
    }
    
    public N endPowervs() {
      return and();
    }
    
  
  }
  public class VsphereNested<N> extends VSpherePlatformSpecFluent<VsphereNested<N>> implements Nested<N>{
    VsphereNested(VSpherePlatformSpec item) {
      this.builder = new VSpherePlatformSpecBuilder(this, item);
    }
    VSpherePlatformSpecBuilder builder;
    
    public N and() {
      return (N) PlatformSpecFluent.this.withVsphere(builder.build());
    }
    
    public N endVsphere() {
      return and();
    }
    
  
  }

}