package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AWSDNSSpecBuilder extends AWSDNSSpecFluent<AWSDNSSpecBuilder> implements VisitableBuilder<AWSDNSSpec,AWSDNSSpecBuilder>{
  public AWSDNSSpecBuilder() {
    this(new AWSDNSSpec());
  }
  
  public AWSDNSSpecBuilder(AWSDNSSpecFluent<?> fluent) {
    this(fluent, new AWSDNSSpec());
  }
  
  public AWSDNSSpecBuilder(AWSDNSSpecFluent<?> fluent,AWSDNSSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AWSDNSSpecBuilder(AWSDNSSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AWSDNSSpecFluent<?> fluent;
  
  public AWSDNSSpec build() {
    AWSDNSSpec buildable = new AWSDNSSpec(fluent.getPrivateZoneIAMRole());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}