package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BuildSpecFluent<A extends BuildSpecFluent<A>> extends BaseFluent<A>{
  public BuildSpecFluent() {
  }
  
  public BuildSpecFluent(BuildSpec instance) {
    this.copyInstance(instance);
  }
  private ConfigMapNameReferenceBuilder additionalTrustedCA;
  private BuildDefaultsBuilder buildDefaults;
  private BuildOverridesBuilder buildOverrides;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BuildSpec instance) {
    instance = (instance != null ? instance : new BuildSpec());
    if (instance != null) {
          this.withAdditionalTrustedCA(instance.getAdditionalTrustedCA());
          this.withBuildDefaults(instance.getBuildDefaults());
          this.withBuildOverrides(instance.getBuildOverrides());
          this.withAdditionalTrustedCA(instance.getAdditionalTrustedCA());
          this.withBuildDefaults(instance.getBuildDefaults());
          this.withBuildOverrides(instance.getBuildOverrides());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ConfigMapNameReference buildAdditionalTrustedCA() {
    return this.additionalTrustedCA != null ? this.additionalTrustedCA.build() : null;
  }
  
  public A withAdditionalTrustedCA(ConfigMapNameReference additionalTrustedCA) {
    this._visitables.remove(this.additionalTrustedCA);
    if (additionalTrustedCA != null) {
        this.additionalTrustedCA = new ConfigMapNameReferenceBuilder(additionalTrustedCA);
        this._visitables.get("additionalTrustedCA").add(this.additionalTrustedCA);
    } else {
        this.additionalTrustedCA = null;
        this._visitables.get("additionalTrustedCA").remove(this.additionalTrustedCA);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalTrustedCA() {
    return this.additionalTrustedCA != null;
  }
  
  public A withNewAdditionalTrustedCA(String name) {
    return (A)withAdditionalTrustedCA(new ConfigMapNameReference(name));
  }
  
  public AdditionalTrustedCANested<A> withNewAdditionalTrustedCA() {
    return new AdditionalTrustedCANested(null);
  }
  
  public AdditionalTrustedCANested<A> withNewAdditionalTrustedCALike(ConfigMapNameReference item) {
    return new AdditionalTrustedCANested(item);
  }
  
  public AdditionalTrustedCANested<A> editAdditionalTrustedCA() {
    return withNewAdditionalTrustedCALike(java.util.Optional.ofNullable(buildAdditionalTrustedCA()).orElse(null));
  }
  
  public AdditionalTrustedCANested<A> editOrNewAdditionalTrustedCA() {
    return withNewAdditionalTrustedCALike(java.util.Optional.ofNullable(buildAdditionalTrustedCA()).orElse(new ConfigMapNameReferenceBuilder().build()));
  }
  
  public AdditionalTrustedCANested<A> editOrNewAdditionalTrustedCALike(ConfigMapNameReference item) {
    return withNewAdditionalTrustedCALike(java.util.Optional.ofNullable(buildAdditionalTrustedCA()).orElse(item));
  }
  
  public BuildDefaults buildBuildDefaults() {
    return this.buildDefaults != null ? this.buildDefaults.build() : null;
  }
  
  public A withBuildDefaults(BuildDefaults buildDefaults) {
    this._visitables.remove(this.buildDefaults);
    if (buildDefaults != null) {
        this.buildDefaults = new BuildDefaultsBuilder(buildDefaults);
        this._visitables.get("buildDefaults").add(this.buildDefaults);
    } else {
        this.buildDefaults = null;
        this._visitables.get("buildDefaults").remove(this.buildDefaults);
    }
    return (A) this;
  }
  
  public boolean hasBuildDefaults() {
    return this.buildDefaults != null;
  }
  
  public BuildDefaultsNested<A> withNewBuildDefaults() {
    return new BuildDefaultsNested(null);
  }
  
  public BuildDefaultsNested<A> withNewBuildDefaultsLike(BuildDefaults item) {
    return new BuildDefaultsNested(item);
  }
  
  public BuildDefaultsNested<A> editBuildDefaults() {
    return withNewBuildDefaultsLike(java.util.Optional.ofNullable(buildBuildDefaults()).orElse(null));
  }
  
  public BuildDefaultsNested<A> editOrNewBuildDefaults() {
    return withNewBuildDefaultsLike(java.util.Optional.ofNullable(buildBuildDefaults()).orElse(new BuildDefaultsBuilder().build()));
  }
  
  public BuildDefaultsNested<A> editOrNewBuildDefaultsLike(BuildDefaults item) {
    return withNewBuildDefaultsLike(java.util.Optional.ofNullable(buildBuildDefaults()).orElse(item));
  }
  
  public BuildOverrides buildBuildOverrides() {
    return this.buildOverrides != null ? this.buildOverrides.build() : null;
  }
  
  public A withBuildOverrides(BuildOverrides buildOverrides) {
    this._visitables.remove(this.buildOverrides);
    if (buildOverrides != null) {
        this.buildOverrides = new BuildOverridesBuilder(buildOverrides);
        this._visitables.get("buildOverrides").add(this.buildOverrides);
    } else {
        this.buildOverrides = null;
        this._visitables.get("buildOverrides").remove(this.buildOverrides);
    }
    return (A) this;
  }
  
  public boolean hasBuildOverrides() {
    return this.buildOverrides != null;
  }
  
  public BuildOverridesNested<A> withNewBuildOverrides() {
    return new BuildOverridesNested(null);
  }
  
  public BuildOverridesNested<A> withNewBuildOverridesLike(BuildOverrides item) {
    return new BuildOverridesNested(item);
  }
  
  public BuildOverridesNested<A> editBuildOverrides() {
    return withNewBuildOverridesLike(java.util.Optional.ofNullable(buildBuildOverrides()).orElse(null));
  }
  
  public BuildOverridesNested<A> editOrNewBuildOverrides() {
    return withNewBuildOverridesLike(java.util.Optional.ofNullable(buildBuildOverrides()).orElse(new BuildOverridesBuilder().build()));
  }
  
  public BuildOverridesNested<A> editOrNewBuildOverridesLike(BuildOverrides item) {
    return withNewBuildOverridesLike(java.util.Optional.ofNullable(buildBuildOverrides()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildSpecFluent that = (BuildSpecFluent) o;
    if (!java.util.Objects.equals(additionalTrustedCA, that.additionalTrustedCA)) return false;
    if (!java.util.Objects.equals(buildDefaults, that.buildDefaults)) return false;
    if (!java.util.Objects.equals(buildOverrides, that.buildOverrides)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(additionalTrustedCA,  buildDefaults,  buildOverrides,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalTrustedCA != null) { sb.append("additionalTrustedCA:"); sb.append(additionalTrustedCA + ","); }
    if (buildDefaults != null) { sb.append("buildDefaults:"); sb.append(buildDefaults + ","); }
    if (buildOverrides != null) { sb.append("buildOverrides:"); sb.append(buildOverrides + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AdditionalTrustedCANested<N> extends ConfigMapNameReferenceFluent<AdditionalTrustedCANested<N>> implements Nested<N>{
    AdditionalTrustedCANested(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    ConfigMapNameReferenceBuilder builder;
    
    public N and() {
      return (N) BuildSpecFluent.this.withAdditionalTrustedCA(builder.build());
    }
    
    public N endAdditionalTrustedCA() {
      return and();
    }
    
  
  }
  public class BuildDefaultsNested<N> extends BuildDefaultsFluent<BuildDefaultsNested<N>> implements Nested<N>{
    BuildDefaultsNested(BuildDefaults item) {
      this.builder = new BuildDefaultsBuilder(this, item);
    }
    BuildDefaultsBuilder builder;
    
    public N and() {
      return (N) BuildSpecFluent.this.withBuildDefaults(builder.build());
    }
    
    public N endBuildDefaults() {
      return and();
    }
    
  
  }
  public class BuildOverridesNested<N> extends BuildOverridesFluent<BuildOverridesNested<N>> implements Nested<N>{
    BuildOverridesNested(BuildOverrides item) {
      this.builder = new BuildOverridesBuilder(this, item);
    }
    BuildOverridesBuilder builder;
    
    public N and() {
      return (N) BuildSpecFluent.this.withBuildOverrides(builder.build());
    }
    
    public N endBuildOverrides() {
      return and();
    }
    
  
  }

}