package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DNSSpecFluent<A extends DNSSpecFluent<A>> extends BaseFluent<A>{
  public DNSSpecFluent() {
  }
  
  public DNSSpecFluent(DNSSpec instance) {
    this.copyInstance(instance);
  }
  private String baseDomain;
  private DNSPlatformSpecBuilder platform;
  private DNSZoneBuilder privateZone;
  private DNSZoneBuilder publicZone;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DNSSpec instance) {
    instance = (instance != null ? instance : new DNSSpec());
    if (instance != null) {
          this.withBaseDomain(instance.getBaseDomain());
          this.withPlatform(instance.getPlatform());
          this.withPrivateZone(instance.getPrivateZone());
          this.withPublicZone(instance.getPublicZone());
          this.withBaseDomain(instance.getBaseDomain());
          this.withPlatform(instance.getPlatform());
          this.withPrivateZone(instance.getPrivateZone());
          this.withPublicZone(instance.getPublicZone());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBaseDomain() {
    return this.baseDomain;
  }
  
  public A withBaseDomain(String baseDomain) {
    this.baseDomain = baseDomain;
    return (A) this;
  }
  
  public boolean hasBaseDomain() {
    return this.baseDomain != null;
  }
  
  public DNSPlatformSpec buildPlatform() {
    return this.platform != null ? this.platform.build() : null;
  }
  
  public A withPlatform(DNSPlatformSpec platform) {
    this._visitables.remove(this.platform);
    if (platform != null) {
        this.platform = new DNSPlatformSpecBuilder(platform);
        this._visitables.get("platform").add(this.platform);
    } else {
        this.platform = null;
        this._visitables.get("platform").remove(this.platform);
    }
    return (A) this;
  }
  
  public boolean hasPlatform() {
    return this.platform != null;
  }
  
  public PlatformNested<A> withNewPlatform() {
    return new PlatformNested(null);
  }
  
  public PlatformNested<A> withNewPlatformLike(DNSPlatformSpec item) {
    return new PlatformNested(item);
  }
  
  public PlatformNested<A> editPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(null));
  }
  
  public PlatformNested<A> editOrNewPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(new DNSPlatformSpecBuilder().build()));
  }
  
  public PlatformNested<A> editOrNewPlatformLike(DNSPlatformSpec item) {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(item));
  }
  
  public DNSZone buildPrivateZone() {
    return this.privateZone != null ? this.privateZone.build() : null;
  }
  
  public A withPrivateZone(DNSZone privateZone) {
    this._visitables.remove(this.privateZone);
    if (privateZone != null) {
        this.privateZone = new DNSZoneBuilder(privateZone);
        this._visitables.get("privateZone").add(this.privateZone);
    } else {
        this.privateZone = null;
        this._visitables.get("privateZone").remove(this.privateZone);
    }
    return (A) this;
  }
  
  public boolean hasPrivateZone() {
    return this.privateZone != null;
  }
  
  public PrivateZoneNested<A> withNewPrivateZone() {
    return new PrivateZoneNested(null);
  }
  
  public PrivateZoneNested<A> withNewPrivateZoneLike(DNSZone item) {
    return new PrivateZoneNested(item);
  }
  
  public PrivateZoneNested<A> editPrivateZone() {
    return withNewPrivateZoneLike(java.util.Optional.ofNullable(buildPrivateZone()).orElse(null));
  }
  
  public PrivateZoneNested<A> editOrNewPrivateZone() {
    return withNewPrivateZoneLike(java.util.Optional.ofNullable(buildPrivateZone()).orElse(new DNSZoneBuilder().build()));
  }
  
  public PrivateZoneNested<A> editOrNewPrivateZoneLike(DNSZone item) {
    return withNewPrivateZoneLike(java.util.Optional.ofNullable(buildPrivateZone()).orElse(item));
  }
  
  public DNSZone buildPublicZone() {
    return this.publicZone != null ? this.publicZone.build() : null;
  }
  
  public A withPublicZone(DNSZone publicZone) {
    this._visitables.remove(this.publicZone);
    if (publicZone != null) {
        this.publicZone = new DNSZoneBuilder(publicZone);
        this._visitables.get("publicZone").add(this.publicZone);
    } else {
        this.publicZone = null;
        this._visitables.get("publicZone").remove(this.publicZone);
    }
    return (A) this;
  }
  
  public boolean hasPublicZone() {
    return this.publicZone != null;
  }
  
  public PublicZoneNested<A> withNewPublicZone() {
    return new PublicZoneNested(null);
  }
  
  public PublicZoneNested<A> withNewPublicZoneLike(DNSZone item) {
    return new PublicZoneNested(item);
  }
  
  public PublicZoneNested<A> editPublicZone() {
    return withNewPublicZoneLike(java.util.Optional.ofNullable(buildPublicZone()).orElse(null));
  }
  
  public PublicZoneNested<A> editOrNewPublicZone() {
    return withNewPublicZoneLike(java.util.Optional.ofNullable(buildPublicZone()).orElse(new DNSZoneBuilder().build()));
  }
  
  public PublicZoneNested<A> editOrNewPublicZoneLike(DNSZone item) {
    return withNewPublicZoneLike(java.util.Optional.ofNullable(buildPublicZone()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DNSSpecFluent that = (DNSSpecFluent) o;
    if (!java.util.Objects.equals(baseDomain, that.baseDomain)) return false;
    if (!java.util.Objects.equals(platform, that.platform)) return false;
    if (!java.util.Objects.equals(privateZone, that.privateZone)) return false;
    if (!java.util.Objects.equals(publicZone, that.publicZone)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(baseDomain,  platform,  privateZone,  publicZone,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseDomain != null) { sb.append("baseDomain:"); sb.append(baseDomain + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (privateZone != null) { sb.append("privateZone:"); sb.append(privateZone + ","); }
    if (publicZone != null) { sb.append("publicZone:"); sb.append(publicZone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PlatformNested<N> extends DNSPlatformSpecFluent<PlatformNested<N>> implements Nested<N>{
    PlatformNested(DNSPlatformSpec item) {
      this.builder = new DNSPlatformSpecBuilder(this, item);
    }
    DNSPlatformSpecBuilder builder;
    
    public N and() {
      return (N) DNSSpecFluent.this.withPlatform(builder.build());
    }
    
    public N endPlatform() {
      return and();
    }
    
  
  }
  public class PrivateZoneNested<N> extends DNSZoneFluent<PrivateZoneNested<N>> implements Nested<N>{
    PrivateZoneNested(DNSZone item) {
      this.builder = new DNSZoneBuilder(this, item);
    }
    DNSZoneBuilder builder;
    
    public N and() {
      return (N) DNSSpecFluent.this.withPrivateZone(builder.build());
    }
    
    public N endPrivateZone() {
      return and();
    }
    
  
  }
  public class PublicZoneNested<N> extends DNSZoneFluent<PublicZoneNested<N>> implements Nested<N>{
    PublicZoneNested(DNSZone item) {
      this.builder = new DNSZoneBuilder(this, item);
    }
    DNSZoneBuilder builder;
    
    public N and() {
      return (N) DNSSpecFluent.this.withPublicZone(builder.build());
    }
    
    public N endPublicZone() {
      return and();
    }
    
  
  }

}