package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageDigestMirrorSetSpecFluent<A extends ImageDigestMirrorSetSpecFluent<A>> extends BaseFluent<A>{
  public ImageDigestMirrorSetSpecFluent() {
  }
  
  public ImageDigestMirrorSetSpecFluent(ImageDigestMirrorSetSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ImageDigestMirrorsBuilder> imageDigestMirrors = new ArrayList<ImageDigestMirrorsBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ImageDigestMirrorSetSpec instance) {
    instance = (instance != null ? instance : new ImageDigestMirrorSetSpec());
    if (instance != null) {
          this.withImageDigestMirrors(instance.getImageDigestMirrors());
          this.withImageDigestMirrors(instance.getImageDigestMirrors());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToImageDigestMirrors(int index,ImageDigestMirrors item) {
    if (this.imageDigestMirrors == null) {this.imageDigestMirrors = new ArrayList<ImageDigestMirrorsBuilder>();}
    ImageDigestMirrorsBuilder builder = new ImageDigestMirrorsBuilder(item);
    if (index < 0 || index >= imageDigestMirrors.size()) { _visitables.get("imageDigestMirrors").add(builder); imageDigestMirrors.add(builder); } else { _visitables.get("imageDigestMirrors").add(index, builder); imageDigestMirrors.add(index, builder);}
    return (A)this;
  }
  
  public A setToImageDigestMirrors(int index,ImageDigestMirrors item) {
    if (this.imageDigestMirrors == null) {this.imageDigestMirrors = new ArrayList<ImageDigestMirrorsBuilder>();}
    ImageDigestMirrorsBuilder builder = new ImageDigestMirrorsBuilder(item);
    if (index < 0 || index >= imageDigestMirrors.size()) { _visitables.get("imageDigestMirrors").add(builder); imageDigestMirrors.add(builder); } else { _visitables.get("imageDigestMirrors").set(index, builder); imageDigestMirrors.set(index, builder);}
    return (A)this;
  }
  
  public A addToImageDigestMirrors(io.fabric8.openshift.api.model.config.v1.ImageDigestMirrors... items) {
    if (this.imageDigestMirrors == null) {this.imageDigestMirrors = new ArrayList<ImageDigestMirrorsBuilder>();}
    for (ImageDigestMirrors item : items) {ImageDigestMirrorsBuilder builder = new ImageDigestMirrorsBuilder(item);_visitables.get("imageDigestMirrors").add(builder);this.imageDigestMirrors.add(builder);} return (A)this;
  }
  
  public A addAllToImageDigestMirrors(Collection<ImageDigestMirrors> items) {
    if (this.imageDigestMirrors == null) {this.imageDigestMirrors = new ArrayList<ImageDigestMirrorsBuilder>();}
    for (ImageDigestMirrors item : items) {ImageDigestMirrorsBuilder builder = new ImageDigestMirrorsBuilder(item);_visitables.get("imageDigestMirrors").add(builder);this.imageDigestMirrors.add(builder);} return (A)this;
  }
  
  public A removeFromImageDigestMirrors(io.fabric8.openshift.api.model.config.v1.ImageDigestMirrors... items) {
    if (this.imageDigestMirrors == null) return (A)this;
    for (ImageDigestMirrors item : items) {ImageDigestMirrorsBuilder builder = new ImageDigestMirrorsBuilder(item);_visitables.get("imageDigestMirrors").remove(builder); this.imageDigestMirrors.remove(builder);} return (A)this;
  }
  
  public A removeAllFromImageDigestMirrors(Collection<ImageDigestMirrors> items) {
    if (this.imageDigestMirrors == null) return (A)this;
    for (ImageDigestMirrors item : items) {ImageDigestMirrorsBuilder builder = new ImageDigestMirrorsBuilder(item);_visitables.get("imageDigestMirrors").remove(builder); this.imageDigestMirrors.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromImageDigestMirrors(Predicate<ImageDigestMirrorsBuilder> predicate) {
    if (imageDigestMirrors == null) return (A) this;
    final Iterator<ImageDigestMirrorsBuilder> each = imageDigestMirrors.iterator();
    final List visitables = _visitables.get("imageDigestMirrors");
    while (each.hasNext()) {
      ImageDigestMirrorsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ImageDigestMirrors> buildImageDigestMirrors() {
    return this.imageDigestMirrors != null ? build(imageDigestMirrors) : null;
  }
  
  public ImageDigestMirrors buildImageDigestMirror(int index) {
    return this.imageDigestMirrors.get(index).build();
  }
  
  public ImageDigestMirrors buildFirstImageDigestMirror() {
    return this.imageDigestMirrors.get(0).build();
  }
  
  public ImageDigestMirrors buildLastImageDigestMirror() {
    return this.imageDigestMirrors.get(imageDigestMirrors.size() - 1).build();
  }
  
  public ImageDigestMirrors buildMatchingImageDigestMirror(Predicate<ImageDigestMirrorsBuilder> predicate) {
      for (ImageDigestMirrorsBuilder item : imageDigestMirrors) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingImageDigestMirror(Predicate<ImageDigestMirrorsBuilder> predicate) {
      for (ImageDigestMirrorsBuilder item : imageDigestMirrors) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withImageDigestMirrors(List<ImageDigestMirrors> imageDigestMirrors) {
    if (this.imageDigestMirrors != null) {
      this._visitables.get("imageDigestMirrors").clear();
    }
    if (imageDigestMirrors != null) {
        this.imageDigestMirrors = new ArrayList();
        for (ImageDigestMirrors item : imageDigestMirrors) {
          this.addToImageDigestMirrors(item);
        }
    } else {
      this.imageDigestMirrors = null;
    }
    return (A) this;
  }
  
  public A withImageDigestMirrors(io.fabric8.openshift.api.model.config.v1.ImageDigestMirrors... imageDigestMirrors) {
    if (this.imageDigestMirrors != null) {this.imageDigestMirrors.clear(); _visitables.remove("imageDigestMirrors"); }
    if (imageDigestMirrors != null) {for (ImageDigestMirrors item :imageDigestMirrors){ this.addToImageDigestMirrors(item);}} return (A) this;
  }
  
  public boolean hasImageDigestMirrors() {
    return this.imageDigestMirrors != null && !this.imageDigestMirrors.isEmpty();
  }
  
  public ImageDigestMirrorsNested<A> addNewImageDigestMirror() {
    return new ImageDigestMirrorsNested(-1, null);
  }
  
  public ImageDigestMirrorsNested<A> addNewImageDigestMirrorLike(ImageDigestMirrors item) {
    return new ImageDigestMirrorsNested(-1, item);
  }
  
  public ImageDigestMirrorsNested<A> setNewImageDigestMirrorLike(int index,ImageDigestMirrors item) {
    return new ImageDigestMirrorsNested(index, item);
  }
  
  public ImageDigestMirrorsNested<A> editImageDigestMirror(int index) {
    if (imageDigestMirrors.size() <= index) throw new RuntimeException("Can't edit imageDigestMirrors. Index exceeds size.");
    return setNewImageDigestMirrorLike(index, buildImageDigestMirror(index));
  }
  
  public ImageDigestMirrorsNested<A> editFirstImageDigestMirror() {
    if (imageDigestMirrors.size() == 0) throw new RuntimeException("Can't edit first imageDigestMirrors. The list is empty.");
    return setNewImageDigestMirrorLike(0, buildImageDigestMirror(0));
  }
  
  public ImageDigestMirrorsNested<A> editLastImageDigestMirror() {
    int index = imageDigestMirrors.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imageDigestMirrors. The list is empty.");
    return setNewImageDigestMirrorLike(index, buildImageDigestMirror(index));
  }
  
  public ImageDigestMirrorsNested<A> editMatchingImageDigestMirror(Predicate<ImageDigestMirrorsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imageDigestMirrors.size();i++) { 
    if (predicate.test(imageDigestMirrors.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imageDigestMirrors. No match found.");
    return setNewImageDigestMirrorLike(index, buildImageDigestMirror(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageDigestMirrorSetSpecFluent that = (ImageDigestMirrorSetSpecFluent) o;
    if (!java.util.Objects.equals(imageDigestMirrors, that.imageDigestMirrors)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(imageDigestMirrors,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (imageDigestMirrors != null && !imageDigestMirrors.isEmpty()) { sb.append("imageDigestMirrors:"); sb.append(imageDigestMirrors + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ImageDigestMirrorsNested<N> extends ImageDigestMirrorsFluent<ImageDigestMirrorsNested<N>> implements Nested<N>{
    ImageDigestMirrorsNested(int index,ImageDigestMirrors item) {
      this.index = index;
      this.builder = new ImageDigestMirrorsBuilder(this, item);
    }
    ImageDigestMirrorsBuilder builder;
    int index;
    
    public N and() {
      return (N) ImageDigestMirrorSetSpecFluent.this.setToImageDigestMirrors(index,builder.build());
    }
    
    public N endImageDigestMirror() {
      return and();
    }
    
  
  }

}