package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AWSPlatformSpecBuilder extends AWSPlatformSpecFluent<AWSPlatformSpecBuilder> implements VisitableBuilder<AWSPlatformSpec,AWSPlatformSpecBuilder>{
  public AWSPlatformSpecBuilder() {
    this(new AWSPlatformSpec());
  }
  
  public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent) {
    this(fluent, new AWSPlatformSpec());
  }
  
  public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent,AWSPlatformSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AWSPlatformSpecBuilder(AWSPlatformSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AWSPlatformSpecFluent<?> fluent;
  
  public AWSPlatformSpec build() {
    AWSPlatformSpec buildable = new AWSPlatformSpec(fluent.buildServiceEndpoints());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}