package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OAuthSpecFluent<A extends OAuthSpecFluent<A>> extends BaseFluent<A>{
  public OAuthSpecFluent() {
  }
  
  public OAuthSpecFluent(OAuthSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<IdentityProviderBuilder> identityProviders = new ArrayList<IdentityProviderBuilder>();
  private OAuthTemplatesBuilder templates;
  private TokenConfigBuilder tokenConfig;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OAuthSpec instance) {
    instance = (instance != null ? instance : new OAuthSpec());
    if (instance != null) {
          this.withIdentityProviders(instance.getIdentityProviders());
          this.withTemplates(instance.getTemplates());
          this.withTokenConfig(instance.getTokenConfig());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToIdentityProviders(int index,IdentityProvider item) {
    if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProviderBuilder>();}
    IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
    if (index < 0 || index >= identityProviders.size()) { _visitables.get("identityProviders").add(builder); identityProviders.add(builder); } else { _visitables.get("identityProviders").add(index, builder); identityProviders.add(index, builder);}
    return (A)this;
  }
  
  public A setToIdentityProviders(int index,IdentityProvider item) {
    if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProviderBuilder>();}
    IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
    if (index < 0 || index >= identityProviders.size()) { _visitables.get("identityProviders").add(builder); identityProviders.add(builder); } else { _visitables.get("identityProviders").set(index, builder); identityProviders.set(index, builder);}
    return (A)this;
  }
  
  public A addToIdentityProviders(io.fabric8.openshift.api.model.config.v1.IdentityProvider... items) {
    if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProviderBuilder>();}
    for (IdentityProvider item : items) {IdentityProviderBuilder builder = new IdentityProviderBuilder(item);_visitables.get("identityProviders").add(builder);this.identityProviders.add(builder);} return (A)this;
  }
  
  public A addAllToIdentityProviders(Collection<IdentityProvider> items) {
    if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProviderBuilder>();}
    for (IdentityProvider item : items) {IdentityProviderBuilder builder = new IdentityProviderBuilder(item);_visitables.get("identityProviders").add(builder);this.identityProviders.add(builder);} return (A)this;
  }
  
  public A removeFromIdentityProviders(io.fabric8.openshift.api.model.config.v1.IdentityProvider... items) {
    if (this.identityProviders == null) return (A)this;
    for (IdentityProvider item : items) {IdentityProviderBuilder builder = new IdentityProviderBuilder(item);_visitables.get("identityProviders").remove(builder); this.identityProviders.remove(builder);} return (A)this;
  }
  
  public A removeAllFromIdentityProviders(Collection<IdentityProvider> items) {
    if (this.identityProviders == null) return (A)this;
    for (IdentityProvider item : items) {IdentityProviderBuilder builder = new IdentityProviderBuilder(item);_visitables.get("identityProviders").remove(builder); this.identityProviders.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromIdentityProviders(Predicate<IdentityProviderBuilder> predicate) {
    if (identityProviders == null) return (A) this;
    final Iterator<IdentityProviderBuilder> each = identityProviders.iterator();
    final List visitables = _visitables.get("identityProviders");
    while (each.hasNext()) {
      IdentityProviderBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<IdentityProvider> buildIdentityProviders() {
    return this.identityProviders != null ? build(identityProviders) : null;
  }
  
  public IdentityProvider buildIdentityProvider(int index) {
    return this.identityProviders.get(index).build();
  }
  
  public IdentityProvider buildFirstIdentityProvider() {
    return this.identityProviders.get(0).build();
  }
  
  public IdentityProvider buildLastIdentityProvider() {
    return this.identityProviders.get(identityProviders.size() - 1).build();
  }
  
  public IdentityProvider buildMatchingIdentityProvider(Predicate<IdentityProviderBuilder> predicate) {
      for (IdentityProviderBuilder item : identityProviders) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingIdentityProvider(Predicate<IdentityProviderBuilder> predicate) {
      for (IdentityProviderBuilder item : identityProviders) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withIdentityProviders(List<IdentityProvider> identityProviders) {
    if (this.identityProviders != null) {
      this._visitables.get("identityProviders").clear();
    }
    if (identityProviders != null) {
        this.identityProviders = new ArrayList();
        for (IdentityProvider item : identityProviders) {
          this.addToIdentityProviders(item);
        }
    } else {
      this.identityProviders = null;
    }
    return (A) this;
  }
  
  public A withIdentityProviders(io.fabric8.openshift.api.model.config.v1.IdentityProvider... identityProviders) {
    if (this.identityProviders != null) {
        this.identityProviders.clear();
        _visitables.remove("identityProviders");
    }
    if (identityProviders != null) {
      for (IdentityProvider item : identityProviders) {
        this.addToIdentityProviders(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasIdentityProviders() {
    return this.identityProviders != null && !this.identityProviders.isEmpty();
  }
  
  public IdentityProvidersNested<A> addNewIdentityProvider() {
    return new IdentityProvidersNested(-1, null);
  }
  
  public IdentityProvidersNested<A> addNewIdentityProviderLike(IdentityProvider item) {
    return new IdentityProvidersNested(-1, item);
  }
  
  public IdentityProvidersNested<A> setNewIdentityProviderLike(int index,IdentityProvider item) {
    return new IdentityProvidersNested(index, item);
  }
  
  public IdentityProvidersNested<A> editIdentityProvider(int index) {
    if (identityProviders.size() <= index) throw new RuntimeException("Can't edit identityProviders. Index exceeds size.");
    return setNewIdentityProviderLike(index, buildIdentityProvider(index));
  }
  
  public IdentityProvidersNested<A> editFirstIdentityProvider() {
    if (identityProviders.size() == 0) throw new RuntimeException("Can't edit first identityProviders. The list is empty.");
    return setNewIdentityProviderLike(0, buildIdentityProvider(0));
  }
  
  public IdentityProvidersNested<A> editLastIdentityProvider() {
    int index = identityProviders.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last identityProviders. The list is empty.");
    return setNewIdentityProviderLike(index, buildIdentityProvider(index));
  }
  
  public IdentityProvidersNested<A> editMatchingIdentityProvider(Predicate<IdentityProviderBuilder> predicate) {
    int index = -1;
    for (int i=0;i<identityProviders.size();i++) { 
    if (predicate.test(identityProviders.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching identityProviders. No match found.");
    return setNewIdentityProviderLike(index, buildIdentityProvider(index));
  }
  
  public OAuthTemplates buildTemplates() {
    return this.templates != null ? this.templates.build() : null;
  }
  
  public A withTemplates(OAuthTemplates templates) {
    this._visitables.remove("templates");
    if (templates != null) {
        this.templates = new OAuthTemplatesBuilder(templates);
        this._visitables.get("templates").add(this.templates);
    } else {
        this.templates = null;
        this._visitables.get("templates").remove(this.templates);
    }
    return (A) this;
  }
  
  public boolean hasTemplates() {
    return this.templates != null;
  }
  
  public TemplatesNested<A> withNewTemplates() {
    return new TemplatesNested(null);
  }
  
  public TemplatesNested<A> withNewTemplatesLike(OAuthTemplates item) {
    return new TemplatesNested(item);
  }
  
  public TemplatesNested<A> editTemplates() {
    return withNewTemplatesLike(java.util.Optional.ofNullable(buildTemplates()).orElse(null));
  }
  
  public TemplatesNested<A> editOrNewTemplates() {
    return withNewTemplatesLike(java.util.Optional.ofNullable(buildTemplates()).orElse(new OAuthTemplatesBuilder().build()));
  }
  
  public TemplatesNested<A> editOrNewTemplatesLike(OAuthTemplates item) {
    return withNewTemplatesLike(java.util.Optional.ofNullable(buildTemplates()).orElse(item));
  }
  
  public TokenConfig buildTokenConfig() {
    return this.tokenConfig != null ? this.tokenConfig.build() : null;
  }
  
  public A withTokenConfig(TokenConfig tokenConfig) {
    this._visitables.remove("tokenConfig");
    if (tokenConfig != null) {
        this.tokenConfig = new TokenConfigBuilder(tokenConfig);
        this._visitables.get("tokenConfig").add(this.tokenConfig);
    } else {
        this.tokenConfig = null;
        this._visitables.get("tokenConfig").remove(this.tokenConfig);
    }
    return (A) this;
  }
  
  public boolean hasTokenConfig() {
    return this.tokenConfig != null;
  }
  
  public TokenConfigNested<A> withNewTokenConfig() {
    return new TokenConfigNested(null);
  }
  
  public TokenConfigNested<A> withNewTokenConfigLike(TokenConfig item) {
    return new TokenConfigNested(item);
  }
  
  public TokenConfigNested<A> editTokenConfig() {
    return withNewTokenConfigLike(java.util.Optional.ofNullable(buildTokenConfig()).orElse(null));
  }
  
  public TokenConfigNested<A> editOrNewTokenConfig() {
    return withNewTokenConfigLike(java.util.Optional.ofNullable(buildTokenConfig()).orElse(new TokenConfigBuilder().build()));
  }
  
  public TokenConfigNested<A> editOrNewTokenConfigLike(TokenConfig item) {
    return withNewTokenConfigLike(java.util.Optional.ofNullable(buildTokenConfig()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OAuthSpecFluent that = (OAuthSpecFluent) o;
    if (!java.util.Objects.equals(identityProviders, that.identityProviders)) return false;
    if (!java.util.Objects.equals(templates, that.templates)) return false;
    if (!java.util.Objects.equals(tokenConfig, that.tokenConfig)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(identityProviders,  templates,  tokenConfig,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (identityProviders != null && !identityProviders.isEmpty()) { sb.append("identityProviders:"); sb.append(identityProviders + ","); }
    if (templates != null) { sb.append("templates:"); sb.append(templates + ","); }
    if (tokenConfig != null) { sb.append("tokenConfig:"); sb.append(tokenConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class IdentityProvidersNested<N> extends IdentityProviderFluent<IdentityProvidersNested<N>> implements Nested<N>{
    IdentityProvidersNested(int index,IdentityProvider item) {
      this.index = index;
      this.builder = new IdentityProviderBuilder(this, item);
    }
    IdentityProviderBuilder builder;
    int index;
    
    public N and() {
      return (N) OAuthSpecFluent.this.setToIdentityProviders(index,builder.build());
    }
    
    public N endIdentityProvider() {
      return and();
    }
    
  
  }
  public class TemplatesNested<N> extends OAuthTemplatesFluent<TemplatesNested<N>> implements Nested<N>{
    TemplatesNested(OAuthTemplates item) {
      this.builder = new OAuthTemplatesBuilder(this, item);
    }
    OAuthTemplatesBuilder builder;
    
    public N and() {
      return (N) OAuthSpecFluent.this.withTemplates(builder.build());
    }
    
    public N endTemplates() {
      return and();
    }
    
  
  }
  public class TokenConfigNested<N> extends TokenConfigFluent<TokenConfigNested<N>> implements Nested<N>{
    TokenConfigNested(TokenConfig item) {
      this.builder = new TokenConfigBuilder(this, item);
    }
    TokenConfigBuilder builder;
    
    public N and() {
      return (N) OAuthSpecFluent.this.withTokenConfig(builder.build());
    }
    
    public N endTokenConfig() {
      return and();
    }
    
  
  }

}