package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AdmissionPluginConfigBuilder extends AdmissionPluginConfigFluent<AdmissionPluginConfigBuilder> implements VisitableBuilder<AdmissionPluginConfig,AdmissionPluginConfigBuilder>{
  public AdmissionPluginConfigBuilder() {
    this(new AdmissionPluginConfig());
  }
  
  public AdmissionPluginConfigBuilder(AdmissionPluginConfigFluent<?> fluent) {
    this(fluent, new AdmissionPluginConfig());
  }
  
  public AdmissionPluginConfigBuilder(AdmissionPluginConfigFluent<?> fluent,AdmissionPluginConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AdmissionPluginConfigBuilder(AdmissionPluginConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AdmissionPluginConfigFluent<?> fluent;
  
  public AdmissionPluginConfig build() {
    AdmissionPluginConfig buildable = new AdmissionPluginConfig(fluent.getConfiguration(),fluent.getLocation());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}