package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AuthenticationStatusFluent<A extends AuthenticationStatusFluent<A>> extends BaseFluent<A>{
  public AuthenticationStatusFluent() {
  }
  
  public AuthenticationStatusFluent(AuthenticationStatus instance) {
    this.copyInstance(instance);
  }
  private ConfigMapNameReferenceBuilder integratedOAuthMetadata;
  private ArrayList<OIDCClientStatusBuilder> oidcClients = new ArrayList<OIDCClientStatusBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AuthenticationStatus instance) {
    instance = (instance != null ? instance : new AuthenticationStatus());
    if (instance != null) {
          this.withIntegratedOAuthMetadata(instance.getIntegratedOAuthMetadata());
          this.withOidcClients(instance.getOidcClients());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ConfigMapNameReference buildIntegratedOAuthMetadata() {
    return this.integratedOAuthMetadata != null ? this.integratedOAuthMetadata.build() : null;
  }
  
  public A withIntegratedOAuthMetadata(ConfigMapNameReference integratedOAuthMetadata) {
    this._visitables.remove("integratedOAuthMetadata");
    if (integratedOAuthMetadata != null) {
        this.integratedOAuthMetadata = new ConfigMapNameReferenceBuilder(integratedOAuthMetadata);
        this._visitables.get("integratedOAuthMetadata").add(this.integratedOAuthMetadata);
    } else {
        this.integratedOAuthMetadata = null;
        this._visitables.get("integratedOAuthMetadata").remove(this.integratedOAuthMetadata);
    }
    return (A) this;
  }
  
  public boolean hasIntegratedOAuthMetadata() {
    return this.integratedOAuthMetadata != null;
  }
  
  public A withNewIntegratedOAuthMetadata(String name) {
    return (A)withIntegratedOAuthMetadata(new ConfigMapNameReference(name));
  }
  
  public IntegratedOAuthMetadataNested<A> withNewIntegratedOAuthMetadata() {
    return new IntegratedOAuthMetadataNested(null);
  }
  
  public IntegratedOAuthMetadataNested<A> withNewIntegratedOAuthMetadataLike(ConfigMapNameReference item) {
    return new IntegratedOAuthMetadataNested(item);
  }
  
  public IntegratedOAuthMetadataNested<A> editIntegratedOAuthMetadata() {
    return withNewIntegratedOAuthMetadataLike(java.util.Optional.ofNullable(buildIntegratedOAuthMetadata()).orElse(null));
  }
  
  public IntegratedOAuthMetadataNested<A> editOrNewIntegratedOAuthMetadata() {
    return withNewIntegratedOAuthMetadataLike(java.util.Optional.ofNullable(buildIntegratedOAuthMetadata()).orElse(new ConfigMapNameReferenceBuilder().build()));
  }
  
  public IntegratedOAuthMetadataNested<A> editOrNewIntegratedOAuthMetadataLike(ConfigMapNameReference item) {
    return withNewIntegratedOAuthMetadataLike(java.util.Optional.ofNullable(buildIntegratedOAuthMetadata()).orElse(item));
  }
  
  public A addToOidcClients(int index,OIDCClientStatus item) {
    if (this.oidcClients == null) {this.oidcClients = new ArrayList<OIDCClientStatusBuilder>();}
    OIDCClientStatusBuilder builder = new OIDCClientStatusBuilder(item);
    if (index < 0 || index >= oidcClients.size()) { _visitables.get("oidcClients").add(builder); oidcClients.add(builder); } else { _visitables.get("oidcClients").add(index, builder); oidcClients.add(index, builder);}
    return (A)this;
  }
  
  public A setToOidcClients(int index,OIDCClientStatus item) {
    if (this.oidcClients == null) {this.oidcClients = new ArrayList<OIDCClientStatusBuilder>();}
    OIDCClientStatusBuilder builder = new OIDCClientStatusBuilder(item);
    if (index < 0 || index >= oidcClients.size()) { _visitables.get("oidcClients").add(builder); oidcClients.add(builder); } else { _visitables.get("oidcClients").set(index, builder); oidcClients.set(index, builder);}
    return (A)this;
  }
  
  public A addToOidcClients(io.fabric8.openshift.api.model.config.v1.OIDCClientStatus... items) {
    if (this.oidcClients == null) {this.oidcClients = new ArrayList<OIDCClientStatusBuilder>();}
    for (OIDCClientStatus item : items) {OIDCClientStatusBuilder builder = new OIDCClientStatusBuilder(item);_visitables.get("oidcClients").add(builder);this.oidcClients.add(builder);} return (A)this;
  }
  
  public A addAllToOidcClients(Collection<OIDCClientStatus> items) {
    if (this.oidcClients == null) {this.oidcClients = new ArrayList<OIDCClientStatusBuilder>();}
    for (OIDCClientStatus item : items) {OIDCClientStatusBuilder builder = new OIDCClientStatusBuilder(item);_visitables.get("oidcClients").add(builder);this.oidcClients.add(builder);} return (A)this;
  }
  
  public A removeFromOidcClients(io.fabric8.openshift.api.model.config.v1.OIDCClientStatus... items) {
    if (this.oidcClients == null) return (A)this;
    for (OIDCClientStatus item : items) {OIDCClientStatusBuilder builder = new OIDCClientStatusBuilder(item);_visitables.get("oidcClients").remove(builder); this.oidcClients.remove(builder);} return (A)this;
  }
  
  public A removeAllFromOidcClients(Collection<OIDCClientStatus> items) {
    if (this.oidcClients == null) return (A)this;
    for (OIDCClientStatus item : items) {OIDCClientStatusBuilder builder = new OIDCClientStatusBuilder(item);_visitables.get("oidcClients").remove(builder); this.oidcClients.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromOidcClients(Predicate<OIDCClientStatusBuilder> predicate) {
    if (oidcClients == null) return (A) this;
    final Iterator<OIDCClientStatusBuilder> each = oidcClients.iterator();
    final List visitables = _visitables.get("oidcClients");
    while (each.hasNext()) {
      OIDCClientStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<OIDCClientStatus> buildOidcClients() {
    return this.oidcClients != null ? build(oidcClients) : null;
  }
  
  public OIDCClientStatus buildOidcClient(int index) {
    return this.oidcClients.get(index).build();
  }
  
  public OIDCClientStatus buildFirstOidcClient() {
    return this.oidcClients.get(0).build();
  }
  
  public OIDCClientStatus buildLastOidcClient() {
    return this.oidcClients.get(oidcClients.size() - 1).build();
  }
  
  public OIDCClientStatus buildMatchingOidcClient(Predicate<OIDCClientStatusBuilder> predicate) {
      for (OIDCClientStatusBuilder item : oidcClients) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingOidcClient(Predicate<OIDCClientStatusBuilder> predicate) {
      for (OIDCClientStatusBuilder item : oidcClients) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withOidcClients(List<OIDCClientStatus> oidcClients) {
    if (this.oidcClients != null) {
      this._visitables.get("oidcClients").clear();
    }
    if (oidcClients != null) {
        this.oidcClients = new ArrayList();
        for (OIDCClientStatus item : oidcClients) {
          this.addToOidcClients(item);
        }
    } else {
      this.oidcClients = null;
    }
    return (A) this;
  }
  
  public A withOidcClients(io.fabric8.openshift.api.model.config.v1.OIDCClientStatus... oidcClients) {
    if (this.oidcClients != null) {
        this.oidcClients.clear();
        _visitables.remove("oidcClients");
    }
    if (oidcClients != null) {
      for (OIDCClientStatus item : oidcClients) {
        this.addToOidcClients(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasOidcClients() {
    return this.oidcClients != null && !this.oidcClients.isEmpty();
  }
  
  public OidcClientsNested<A> addNewOidcClient() {
    return new OidcClientsNested(-1, null);
  }
  
  public OidcClientsNested<A> addNewOidcClientLike(OIDCClientStatus item) {
    return new OidcClientsNested(-1, item);
  }
  
  public OidcClientsNested<A> setNewOidcClientLike(int index,OIDCClientStatus item) {
    return new OidcClientsNested(index, item);
  }
  
  public OidcClientsNested<A> editOidcClient(int index) {
    if (oidcClients.size() <= index) throw new RuntimeException("Can't edit oidcClients. Index exceeds size.");
    return setNewOidcClientLike(index, buildOidcClient(index));
  }
  
  public OidcClientsNested<A> editFirstOidcClient() {
    if (oidcClients.size() == 0) throw new RuntimeException("Can't edit first oidcClients. The list is empty.");
    return setNewOidcClientLike(0, buildOidcClient(0));
  }
  
  public OidcClientsNested<A> editLastOidcClient() {
    int index = oidcClients.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last oidcClients. The list is empty.");
    return setNewOidcClientLike(index, buildOidcClient(index));
  }
  
  public OidcClientsNested<A> editMatchingOidcClient(Predicate<OIDCClientStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<oidcClients.size();i++) { 
    if (predicate.test(oidcClients.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching oidcClients. No match found.");
    return setNewOidcClientLike(index, buildOidcClient(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AuthenticationStatusFluent that = (AuthenticationStatusFluent) o;
    if (!java.util.Objects.equals(integratedOAuthMetadata, that.integratedOAuthMetadata)) return false;
    if (!java.util.Objects.equals(oidcClients, that.oidcClients)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(integratedOAuthMetadata,  oidcClients,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (integratedOAuthMetadata != null) { sb.append("integratedOAuthMetadata:"); sb.append(integratedOAuthMetadata + ","); }
    if (oidcClients != null && !oidcClients.isEmpty()) { sb.append("oidcClients:"); sb.append(oidcClients + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class IntegratedOAuthMetadataNested<N> extends ConfigMapNameReferenceFluent<IntegratedOAuthMetadataNested<N>> implements Nested<N>{
    IntegratedOAuthMetadataNested(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    ConfigMapNameReferenceBuilder builder;
    
    public N and() {
      return (N) AuthenticationStatusFluent.this.withIntegratedOAuthMetadata(builder.build());
    }
    
    public N endIntegratedOAuthMetadata() {
      return and();
    }
    
  
  }
  public class OidcClientsNested<N> extends OIDCClientStatusFluent<OidcClientsNested<N>> implements Nested<N>{
    OidcClientsNested(int index,OIDCClientStatus item) {
      this.index = index;
      this.builder = new OIDCClientStatusBuilder(this, item);
    }
    OIDCClientStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) AuthenticationStatusFluent.this.setToOidcClients(index,builder.build());
    }
    
    public N endOidcClient() {
      return and();
    }
    
  
  }

}