package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BuildDefaultsFluent<A extends BuildDefaultsFluent<A>> extends BaseFluent<A>{
  public BuildDefaultsFluent() {
  }
  
  public BuildDefaultsFluent(BuildDefaults instance) {
    this.copyInstance(instance);
  }
  private ProxySpecBuilder defaultProxy;
  private ArrayList<EnvVarBuilder> env = new ArrayList<EnvVarBuilder>();
  private ProxySpecBuilder gitProxy;
  private ArrayList<ImageLabelBuilder> imageLabels = new ArrayList<ImageLabelBuilder>();
  private ResourceRequirementsBuilder resources;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BuildDefaults instance) {
    instance = (instance != null ? instance : new BuildDefaults());
    if (instance != null) {
          this.withDefaultProxy(instance.getDefaultProxy());
          this.withEnv(instance.getEnv());
          this.withGitProxy(instance.getGitProxy());
          this.withImageLabels(instance.getImageLabels());
          this.withResources(instance.getResources());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ProxySpec buildDefaultProxy() {
    return this.defaultProxy != null ? this.defaultProxy.build() : null;
  }
  
  public A withDefaultProxy(ProxySpec defaultProxy) {
    this._visitables.remove("defaultProxy");
    if (defaultProxy != null) {
        this.defaultProxy = new ProxySpecBuilder(defaultProxy);
        this._visitables.get("defaultProxy").add(this.defaultProxy);
    } else {
        this.defaultProxy = null;
        this._visitables.get("defaultProxy").remove(this.defaultProxy);
    }
    return (A) this;
  }
  
  public boolean hasDefaultProxy() {
    return this.defaultProxy != null;
  }
  
  public DefaultProxyNested<A> withNewDefaultProxy() {
    return new DefaultProxyNested(null);
  }
  
  public DefaultProxyNested<A> withNewDefaultProxyLike(ProxySpec item) {
    return new DefaultProxyNested(item);
  }
  
  public DefaultProxyNested<A> editDefaultProxy() {
    return withNewDefaultProxyLike(java.util.Optional.ofNullable(buildDefaultProxy()).orElse(null));
  }
  
  public DefaultProxyNested<A> editOrNewDefaultProxy() {
    return withNewDefaultProxyLike(java.util.Optional.ofNullable(buildDefaultProxy()).orElse(new ProxySpecBuilder().build()));
  }
  
  public DefaultProxyNested<A> editOrNewDefaultProxyLike(ProxySpec item) {
    return withNewDefaultProxyLike(java.util.Optional.ofNullable(buildDefaultProxy()).orElse(item));
  }
  
  public A addToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= env.size()) { _visitables.get("env").add(builder); env.add(builder); } else { _visitables.get("env").add(index, builder); env.add(index, builder);}
    return (A)this;
  }
  
  public A setToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= env.size()) { _visitables.get("env").add(builder); env.add(builder); } else { _visitables.get("env").set(index, builder); env.set(index, builder);}
    return (A)this;
  }
  
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  
  public A addAllToEnv(Collection<EnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) return (A)this;
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").remove(builder); this.env.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEnv(Collection<EnvVar> items) {
    if (this.env == null) return (A)this;
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").remove(builder); this.env.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate) {
    if (env == null) return (A) this;
    final Iterator<EnvVarBuilder> each = env.iterator();
    final List visitables = _visitables.get("env");
    while (each.hasNext()) {
      EnvVarBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<EnvVar> buildEnv() {
    return this.env != null ? build(env) : null;
  }
  
  public EnvVar buildEnv(int index) {
    return this.env.get(index).build();
  }
  
  public EnvVar buildFirstEnv() {
    return this.env.get(0).build();
  }
  
  public EnvVar buildLastEnv() {
    return this.env.get(env.size() - 1).build();
  }
  
  public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
      for (EnvVarBuilder item : env) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
      for (EnvVarBuilder item : env) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEnv(List<EnvVar> env) {
    if (this.env != null) {
      this._visitables.get("env").clear();
    }
    if (env != null) {
        this.env = new ArrayList();
        for (EnvVar item : env) {
          this.addToEnv(item);
        }
    } else {
      this.env = null;
    }
    return (A) this;
  }
  
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {
        this.env.clear();
        _visitables.remove("env");
    }
    if (env != null) {
      for (EnvVar item : env) {
        this.addToEnv(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEnv() {
    return this.env != null && !this.env.isEmpty();
  }
  
  public EnvNested<A> addNewEnv() {
    return new EnvNested(-1, null);
  }
  
  public EnvNested<A> addNewEnvLike(EnvVar item) {
    return new EnvNested(-1, item);
  }
  
  public EnvNested<A> setNewEnvLike(int index,EnvVar item) {
    return new EnvNested(index, item);
  }
  
  public EnvNested<A> editEnv(int index) {
    if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
    return setNewEnvLike(index, buildEnv(index));
  }
  
  public EnvNested<A> editFirstEnv() {
    if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
    return setNewEnvLike(0, buildEnv(0));
  }
  
  public EnvNested<A> editLastEnv() {
    int index = env.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
    return setNewEnvLike(index, buildEnv(index));
  }
  
  public EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
    int index = -1;
    for (int i=0;i<env.size();i++) { 
    if (predicate.test(env.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
    return setNewEnvLike(index, buildEnv(index));
  }
  
  public ProxySpec buildGitProxy() {
    return this.gitProxy != null ? this.gitProxy.build() : null;
  }
  
  public A withGitProxy(ProxySpec gitProxy) {
    this._visitables.remove("gitProxy");
    if (gitProxy != null) {
        this.gitProxy = new ProxySpecBuilder(gitProxy);
        this._visitables.get("gitProxy").add(this.gitProxy);
    } else {
        this.gitProxy = null;
        this._visitables.get("gitProxy").remove(this.gitProxy);
    }
    return (A) this;
  }
  
  public boolean hasGitProxy() {
    return this.gitProxy != null;
  }
  
  public GitProxyNested<A> withNewGitProxy() {
    return new GitProxyNested(null);
  }
  
  public GitProxyNested<A> withNewGitProxyLike(ProxySpec item) {
    return new GitProxyNested(item);
  }
  
  public GitProxyNested<A> editGitProxy() {
    return withNewGitProxyLike(java.util.Optional.ofNullable(buildGitProxy()).orElse(null));
  }
  
  public GitProxyNested<A> editOrNewGitProxy() {
    return withNewGitProxyLike(java.util.Optional.ofNullable(buildGitProxy()).orElse(new ProxySpecBuilder().build()));
  }
  
  public GitProxyNested<A> editOrNewGitProxyLike(ProxySpec item) {
    return withNewGitProxyLike(java.util.Optional.ofNullable(buildGitProxy()).orElse(item));
  }
  
  public A addToImageLabels(int index,ImageLabel item) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    ImageLabelBuilder builder = new ImageLabelBuilder(item);
    if (index < 0 || index >= imageLabels.size()) { _visitables.get("imageLabels").add(builder); imageLabels.add(builder); } else { _visitables.get("imageLabels").add(index, builder); imageLabels.add(index, builder);}
    return (A)this;
  }
  
  public A setToImageLabels(int index,ImageLabel item) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    ImageLabelBuilder builder = new ImageLabelBuilder(item);
    if (index < 0 || index >= imageLabels.size()) { _visitables.get("imageLabels").add(builder); imageLabels.add(builder); } else { _visitables.get("imageLabels").set(index, builder); imageLabels.set(index, builder);}
    return (A)this;
  }
  
  public A addToImageLabels(io.fabric8.openshift.api.model.config.v1.ImageLabel... items) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").add(builder);this.imageLabels.add(builder);} return (A)this;
  }
  
  public A addAllToImageLabels(Collection<ImageLabel> items) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").add(builder);this.imageLabels.add(builder);} return (A)this;
  }
  
  public A removeFromImageLabels(io.fabric8.openshift.api.model.config.v1.ImageLabel... items) {
    if (this.imageLabels == null) return (A)this;
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").remove(builder); this.imageLabels.remove(builder);} return (A)this;
  }
  
  public A removeAllFromImageLabels(Collection<ImageLabel> items) {
    if (this.imageLabels == null) return (A)this;
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").remove(builder); this.imageLabels.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromImageLabels(Predicate<ImageLabelBuilder> predicate) {
    if (imageLabels == null) return (A) this;
    final Iterator<ImageLabelBuilder> each = imageLabels.iterator();
    final List visitables = _visitables.get("imageLabels");
    while (each.hasNext()) {
      ImageLabelBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ImageLabel> buildImageLabels() {
    return this.imageLabels != null ? build(imageLabels) : null;
  }
  
  public ImageLabel buildImageLabel(int index) {
    return this.imageLabels.get(index).build();
  }
  
  public ImageLabel buildFirstImageLabel() {
    return this.imageLabels.get(0).build();
  }
  
  public ImageLabel buildLastImageLabel() {
    return this.imageLabels.get(imageLabels.size() - 1).build();
  }
  
  public ImageLabel buildMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
      for (ImageLabelBuilder item : imageLabels) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
      for (ImageLabelBuilder item : imageLabels) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withImageLabels(List<ImageLabel> imageLabels) {
    if (this.imageLabels != null) {
      this._visitables.get("imageLabels").clear();
    }
    if (imageLabels != null) {
        this.imageLabels = new ArrayList();
        for (ImageLabel item : imageLabels) {
          this.addToImageLabels(item);
        }
    } else {
      this.imageLabels = null;
    }
    return (A) this;
  }
  
  public A withImageLabels(io.fabric8.openshift.api.model.config.v1.ImageLabel... imageLabels) {
    if (this.imageLabels != null) {
        this.imageLabels.clear();
        _visitables.remove("imageLabels");
    }
    if (imageLabels != null) {
      for (ImageLabel item : imageLabels) {
        this.addToImageLabels(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasImageLabels() {
    return this.imageLabels != null && !this.imageLabels.isEmpty();
  }
  
  public A addNewImageLabel(String name,String value) {
    return (A)addToImageLabels(new ImageLabel(name, value));
  }
  
  public ImageLabelsNested<A> addNewImageLabel() {
    return new ImageLabelsNested(-1, null);
  }
  
  public ImageLabelsNested<A> addNewImageLabelLike(ImageLabel item) {
    return new ImageLabelsNested(-1, item);
  }
  
  public ImageLabelsNested<A> setNewImageLabelLike(int index,ImageLabel item) {
    return new ImageLabelsNested(index, item);
  }
  
  public ImageLabelsNested<A> editImageLabel(int index) {
    if (imageLabels.size() <= index) throw new RuntimeException("Can't edit imageLabels. Index exceeds size.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  
  public ImageLabelsNested<A> editFirstImageLabel() {
    if (imageLabels.size() == 0) throw new RuntimeException("Can't edit first imageLabels. The list is empty.");
    return setNewImageLabelLike(0, buildImageLabel(0));
  }
  
  public ImageLabelsNested<A> editLastImageLabel() {
    int index = imageLabels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imageLabels. The list is empty.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  
  public ImageLabelsNested<A> editMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imageLabels.size();i++) { 
    if (predicate.test(imageLabels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imageLabels. No match found.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  
  public ResourceRequirements buildResources() {
    return this.resources != null ? this.resources.build() : null;
  }
  
  public A withResources(ResourceRequirements resources) {
    this._visitables.remove("resources");
    if (resources != null) {
        this.resources = new ResourceRequirementsBuilder(resources);
        this._visitables.get("resources").add(this.resources);
    } else {
        this.resources = null;
        this._visitables.get("resources").remove(this.resources);
    }
    return (A) this;
  }
  
  public boolean hasResources() {
    return this.resources != null;
  }
  
  public ResourcesNested<A> withNewResources() {
    return new ResourcesNested(null);
  }
  
  public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new ResourcesNested(item);
  }
  
  public ResourcesNested<A> editResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(null));
  }
  
  public ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(new ResourceRequirementsBuilder().build()));
  }
  
  public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildDefaultsFluent that = (BuildDefaultsFluent) o;
    if (!java.util.Objects.equals(defaultProxy, that.defaultProxy)) return false;
    if (!java.util.Objects.equals(env, that.env)) return false;
    if (!java.util.Objects.equals(gitProxy, that.gitProxy)) return false;
    if (!java.util.Objects.equals(imageLabels, that.imageLabels)) return false;
    if (!java.util.Objects.equals(resources, that.resources)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(defaultProxy,  env,  gitProxy,  imageLabels,  resources,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (defaultProxy != null) { sb.append("defaultProxy:"); sb.append(defaultProxy + ","); }
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (gitProxy != null) { sb.append("gitProxy:"); sb.append(gitProxy + ","); }
    if (imageLabels != null && !imageLabels.isEmpty()) { sb.append("imageLabels:"); sb.append(imageLabels + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DefaultProxyNested<N> extends ProxySpecFluent<DefaultProxyNested<N>> implements Nested<N>{
    DefaultProxyNested(ProxySpec item) {
      this.builder = new ProxySpecBuilder(this, item);
    }
    ProxySpecBuilder builder;
    
    public N and() {
      return (N) BuildDefaultsFluent.this.withDefaultProxy(builder.build());
    }
    
    public N endDefaultProxy() {
      return and();
    }
    
  
  }
  public class EnvNested<N> extends EnvVarFluent<EnvNested<N>> implements Nested<N>{
    EnvNested(int index,EnvVar item) {
      this.index = index;
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvVarBuilder builder;
    int index;
    
    public N and() {
      return (N) BuildDefaultsFluent.this.setToEnv(index,builder.build());
    }
    
    public N endEnv() {
      return and();
    }
    
  
  }
  public class GitProxyNested<N> extends ProxySpecFluent<GitProxyNested<N>> implements Nested<N>{
    GitProxyNested(ProxySpec item) {
      this.builder = new ProxySpecBuilder(this, item);
    }
    ProxySpecBuilder builder;
    
    public N and() {
      return (N) BuildDefaultsFluent.this.withGitProxy(builder.build());
    }
    
    public N endGitProxy() {
      return and();
    }
    
  
  }
  public class ImageLabelsNested<N> extends ImageLabelFluent<ImageLabelsNested<N>> implements Nested<N>{
    ImageLabelsNested(int index,ImageLabel item) {
      this.index = index;
      this.builder = new ImageLabelBuilder(this, item);
    }
    ImageLabelBuilder builder;
    int index;
    
    public N and() {
      return (N) BuildDefaultsFluent.this.setToImageLabels(index,builder.build());
    }
    
    public N endImageLabel() {
      return and();
    }
    
  
  }
  public class ResourcesNested<N> extends ResourceRequirementsFluent<ResourcesNested<N>> implements Nested<N>{
    ResourcesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) BuildDefaultsFluent.this.withResources(builder.build());
    }
    
    public N endResources() {
      return and();
    }
    
  
  }

}