package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CloudLoadBalancerIPsBuilder extends CloudLoadBalancerIPsFluent<CloudLoadBalancerIPsBuilder> implements VisitableBuilder<CloudLoadBalancerIPs,CloudLoadBalancerIPsBuilder>{
  public CloudLoadBalancerIPsBuilder() {
    this(new CloudLoadBalancerIPs());
  }
  
  public CloudLoadBalancerIPsBuilder(CloudLoadBalancerIPsFluent<?> fluent) {
    this(fluent, new CloudLoadBalancerIPs());
  }
  
  public CloudLoadBalancerIPsBuilder(CloudLoadBalancerIPsFluent<?> fluent,CloudLoadBalancerIPs instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CloudLoadBalancerIPsBuilder(CloudLoadBalancerIPs instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CloudLoadBalancerIPsFluent<?> fluent;
  
  public CloudLoadBalancerIPs build() {
    CloudLoadBalancerIPs buildable = new CloudLoadBalancerIPs(fluent.getApiIntLoadBalancerIPs(),fluent.getApiLoadBalancerIPs(),fluent.getIngressLoadBalancerIPs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}