package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class FeatureGateTestsFluent<A extends FeatureGateTestsFluent<A>> extends BaseFluent<A>{
  public FeatureGateTestsFluent() {
  }
  
  public FeatureGateTestsFluent(FeatureGateTests instance) {
    this.copyInstance(instance);
  }
  private String featureGate;
  private ArrayList<TestDetailsBuilder> tests = new ArrayList<TestDetailsBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(FeatureGateTests instance) {
    instance = (instance != null ? instance : new FeatureGateTests());
    if (instance != null) {
          this.withFeatureGate(instance.getFeatureGate());
          this.withTests(instance.getTests());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getFeatureGate() {
    return this.featureGate;
  }
  
  public A withFeatureGate(String featureGate) {
    this.featureGate = featureGate;
    return (A) this;
  }
  
  public boolean hasFeatureGate() {
    return this.featureGate != null;
  }
  
  public A addToTests(int index,TestDetails item) {
    if (this.tests == null) {this.tests = new ArrayList<TestDetailsBuilder>();}
    TestDetailsBuilder builder = new TestDetailsBuilder(item);
    if (index < 0 || index >= tests.size()) { _visitables.get("tests").add(builder); tests.add(builder); } else { _visitables.get("tests").add(index, builder); tests.add(index, builder);}
    return (A)this;
  }
  
  public A setToTests(int index,TestDetails item) {
    if (this.tests == null) {this.tests = new ArrayList<TestDetailsBuilder>();}
    TestDetailsBuilder builder = new TestDetailsBuilder(item);
    if (index < 0 || index >= tests.size()) { _visitables.get("tests").add(builder); tests.add(builder); } else { _visitables.get("tests").set(index, builder); tests.set(index, builder);}
    return (A)this;
  }
  
  public A addToTests(io.fabric8.openshift.api.model.config.v1.TestDetails... items) {
    if (this.tests == null) {this.tests = new ArrayList<TestDetailsBuilder>();}
    for (TestDetails item : items) {TestDetailsBuilder builder = new TestDetailsBuilder(item);_visitables.get("tests").add(builder);this.tests.add(builder);} return (A)this;
  }
  
  public A addAllToTests(Collection<TestDetails> items) {
    if (this.tests == null) {this.tests = new ArrayList<TestDetailsBuilder>();}
    for (TestDetails item : items) {TestDetailsBuilder builder = new TestDetailsBuilder(item);_visitables.get("tests").add(builder);this.tests.add(builder);} return (A)this;
  }
  
  public A removeFromTests(io.fabric8.openshift.api.model.config.v1.TestDetails... items) {
    if (this.tests == null) return (A)this;
    for (TestDetails item : items) {TestDetailsBuilder builder = new TestDetailsBuilder(item);_visitables.get("tests").remove(builder); this.tests.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTests(Collection<TestDetails> items) {
    if (this.tests == null) return (A)this;
    for (TestDetails item : items) {TestDetailsBuilder builder = new TestDetailsBuilder(item);_visitables.get("tests").remove(builder); this.tests.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTests(Predicate<TestDetailsBuilder> predicate) {
    if (tests == null) return (A) this;
    final Iterator<TestDetailsBuilder> each = tests.iterator();
    final List visitables = _visitables.get("tests");
    while (each.hasNext()) {
      TestDetailsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TestDetails> buildTests() {
    return this.tests != null ? build(tests) : null;
  }
  
  public TestDetails buildTest(int index) {
    return this.tests.get(index).build();
  }
  
  public TestDetails buildFirstTest() {
    return this.tests.get(0).build();
  }
  
  public TestDetails buildLastTest() {
    return this.tests.get(tests.size() - 1).build();
  }
  
  public TestDetails buildMatchingTest(Predicate<TestDetailsBuilder> predicate) {
      for (TestDetailsBuilder item : tests) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTest(Predicate<TestDetailsBuilder> predicate) {
      for (TestDetailsBuilder item : tests) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTests(List<TestDetails> tests) {
    if (this.tests != null) {
      this._visitables.get("tests").clear();
    }
    if (tests != null) {
        this.tests = new ArrayList();
        for (TestDetails item : tests) {
          this.addToTests(item);
        }
    } else {
      this.tests = null;
    }
    return (A) this;
  }
  
  public A withTests(io.fabric8.openshift.api.model.config.v1.TestDetails... tests) {
    if (this.tests != null) {
        this.tests.clear();
        _visitables.remove("tests");
    }
    if (tests != null) {
      for (TestDetails item : tests) {
        this.addToTests(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTests() {
    return this.tests != null && !this.tests.isEmpty();
  }
  
  public A addNewTest(String testName) {
    return (A)addToTests(new TestDetails(testName));
  }
  
  public TestsNested<A> addNewTest() {
    return new TestsNested(-1, null);
  }
  
  public TestsNested<A> addNewTestLike(TestDetails item) {
    return new TestsNested(-1, item);
  }
  
  public TestsNested<A> setNewTestLike(int index,TestDetails item) {
    return new TestsNested(index, item);
  }
  
  public TestsNested<A> editTest(int index) {
    if (tests.size() <= index) throw new RuntimeException("Can't edit tests. Index exceeds size.");
    return setNewTestLike(index, buildTest(index));
  }
  
  public TestsNested<A> editFirstTest() {
    if (tests.size() == 0) throw new RuntimeException("Can't edit first tests. The list is empty.");
    return setNewTestLike(0, buildTest(0));
  }
  
  public TestsNested<A> editLastTest() {
    int index = tests.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tests. The list is empty.");
    return setNewTestLike(index, buildTest(index));
  }
  
  public TestsNested<A> editMatchingTest(Predicate<TestDetailsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tests.size();i++) { 
    if (predicate.test(tests.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tests. No match found.");
    return setNewTestLike(index, buildTest(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    FeatureGateTestsFluent that = (FeatureGateTestsFluent) o;
    if (!java.util.Objects.equals(featureGate, that.featureGate)) return false;
    if (!java.util.Objects.equals(tests, that.tests)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(featureGate,  tests,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (featureGate != null) { sb.append("featureGate:"); sb.append(featureGate + ","); }
    if (tests != null && !tests.isEmpty()) { sb.append("tests:"); sb.append(tests + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TestsNested<N> extends TestDetailsFluent<TestsNested<N>> implements Nested<N>{
    TestsNested(int index,TestDetails item) {
      this.index = index;
      this.builder = new TestDetailsBuilder(this, item);
    }
    TestDetailsBuilder builder;
    int index;
    
    public N and() {
      return (N) FeatureGateTestsFluent.this.setToTests(index,builder.build());
    }
    
    public N endTest() {
      return and();
    }
    
  
  }

}