package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GCPPlatformStatusBuilder extends GCPPlatformStatusFluent<GCPPlatformStatusBuilder> implements VisitableBuilder<GCPPlatformStatus,GCPPlatformStatusBuilder>{
  public GCPPlatformStatusBuilder() {
    this(new GCPPlatformStatus());
  }
  
  public GCPPlatformStatusBuilder(GCPPlatformStatusFluent<?> fluent) {
    this(fluent, new GCPPlatformStatus());
  }
  
  public GCPPlatformStatusBuilder(GCPPlatformStatusFluent<?> fluent,GCPPlatformStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GCPPlatformStatusBuilder(GCPPlatformStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GCPPlatformStatusFluent<?> fluent;
  
  public GCPPlatformStatus build() {
    GCPPlatformStatus buildable = new GCPPlatformStatus(fluent.buildCloudLoadBalancerConfig(),fluent.getProjectID(),fluent.getRegion(),fluent.buildResourceLabels(),fluent.buildResourceTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}