package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkDiagnosticsSourcePlacementBuilder extends NetworkDiagnosticsSourcePlacementFluent<NetworkDiagnosticsSourcePlacementBuilder> implements VisitableBuilder<NetworkDiagnosticsSourcePlacement,NetworkDiagnosticsSourcePlacementBuilder>{
  public NetworkDiagnosticsSourcePlacementBuilder() {
    this(new NetworkDiagnosticsSourcePlacement());
  }
  
  public NetworkDiagnosticsSourcePlacementBuilder(NetworkDiagnosticsSourcePlacementFluent<?> fluent) {
    this(fluent, new NetworkDiagnosticsSourcePlacement());
  }
  
  public NetworkDiagnosticsSourcePlacementBuilder(NetworkDiagnosticsSourcePlacementFluent<?> fluent,NetworkDiagnosticsSourcePlacement instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkDiagnosticsSourcePlacementBuilder(NetworkDiagnosticsSourcePlacement instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkDiagnosticsSourcePlacementFluent<?> fluent;
  
  public NetworkDiagnosticsSourcePlacement build() {
    NetworkDiagnosticsSourcePlacement buildable = new NetworkDiagnosticsSourcePlacement(fluent.getNodeSelector(),fluent.getTolerations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}