package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PrefixedClaimMappingBuilder extends PrefixedClaimMappingFluent<PrefixedClaimMappingBuilder> implements VisitableBuilder<PrefixedClaimMapping,PrefixedClaimMappingBuilder>{
  public PrefixedClaimMappingBuilder() {
    this(new PrefixedClaimMapping());
  }
  
  public PrefixedClaimMappingBuilder(PrefixedClaimMappingFluent<?> fluent) {
    this(fluent, new PrefixedClaimMapping());
  }
  
  public PrefixedClaimMappingBuilder(PrefixedClaimMappingFluent<?> fluent,PrefixedClaimMapping instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PrefixedClaimMappingBuilder(PrefixedClaimMapping instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PrefixedClaimMappingFluent<?> fluent;
  
  public PrefixedClaimMapping build() {
    PrefixedClaimMapping buildable = new PrefixedClaimMapping(fluent.getClaim(),fluent.getPrefix());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}