package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServingInfoFluent<A extends ServingInfoFluent<A>> extends BaseFluent<A>{
  public ServingInfoFluent() {
  }
  
  public ServingInfoFluent(ServingInfo instance) {
    this.copyInstance(instance);
  }
  private String bindAddress;
  private String bindNetwork;
  private String certFile;
  private List<String> cipherSuites = new ArrayList<String>();
  private String clientCA;
  private String keyFile;
  private String minTLSVersion;
  private ArrayList<NamedCertificateBuilder> namedCertificates = new ArrayList<NamedCertificateBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ServingInfo instance) {
    instance = (instance != null ? instance : new ServingInfo());
    if (instance != null) {
          this.withBindAddress(instance.getBindAddress());
          this.withBindNetwork(instance.getBindNetwork());
          this.withCertFile(instance.getCertFile());
          this.withCipherSuites(instance.getCipherSuites());
          this.withClientCA(instance.getClientCA());
          this.withKeyFile(instance.getKeyFile());
          this.withMinTLSVersion(instance.getMinTLSVersion());
          this.withNamedCertificates(instance.getNamedCertificates());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBindAddress() {
    return this.bindAddress;
  }
  
  public A withBindAddress(String bindAddress) {
    this.bindAddress = bindAddress;
    return (A) this;
  }
  
  public boolean hasBindAddress() {
    return this.bindAddress != null;
  }
  
  public String getBindNetwork() {
    return this.bindNetwork;
  }
  
  public A withBindNetwork(String bindNetwork) {
    this.bindNetwork = bindNetwork;
    return (A) this;
  }
  
  public boolean hasBindNetwork() {
    return this.bindNetwork != null;
  }
  
  public String getCertFile() {
    return this.certFile;
  }
  
  public A withCertFile(String certFile) {
    this.certFile = certFile;
    return (A) this;
  }
  
  public boolean hasCertFile() {
    return this.certFile != null;
  }
  
  public A addToCipherSuites(int index,String item) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    this.cipherSuites.add(index, item);
    return (A)this;
  }
  
  public A setToCipherSuites(int index,String item) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    this.cipherSuites.set(index, item); return (A)this;
  }
  
  public A addToCipherSuites(java.lang.String... items) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    for (String item : items) {this.cipherSuites.add(item);} return (A)this;
  }
  
  public A addAllToCipherSuites(Collection<String> items) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    for (String item : items) {this.cipherSuites.add(item);} return (A)this;
  }
  
  public A removeFromCipherSuites(java.lang.String... items) {
    if (this.cipherSuites == null) return (A)this;
    for (String item : items) { this.cipherSuites.remove(item);} return (A)this;
  }
  
  public A removeAllFromCipherSuites(Collection<String> items) {
    if (this.cipherSuites == null) return (A)this;
    for (String item : items) { this.cipherSuites.remove(item);} return (A)this;
  }
  
  public List<String> getCipherSuites() {
    return this.cipherSuites;
  }
  
  public String getCipherSuite(int index) {
    return this.cipherSuites.get(index);
  }
  
  public String getFirstCipherSuite() {
    return this.cipherSuites.get(0);
  }
  
  public String getLastCipherSuite() {
    return this.cipherSuites.get(cipherSuites.size() - 1);
  }
  
  public String getMatchingCipherSuite(Predicate<String> predicate) {
      for (String item : cipherSuites) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCipherSuite(Predicate<String> predicate) {
      for (String item : cipherSuites) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCipherSuites(List<String> cipherSuites) {
    if (cipherSuites != null) {
        this.cipherSuites = new ArrayList();
        for (String item : cipherSuites) {
          this.addToCipherSuites(item);
        }
    } else {
      this.cipherSuites = null;
    }
    return (A) this;
  }
  
  public A withCipherSuites(java.lang.String... cipherSuites) {
    if (this.cipherSuites != null) {
        this.cipherSuites.clear();
        _visitables.remove("cipherSuites");
    }
    if (cipherSuites != null) {
      for (String item : cipherSuites) {
        this.addToCipherSuites(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasCipherSuites() {
    return this.cipherSuites != null && !this.cipherSuites.isEmpty();
  }
  
  public String getClientCA() {
    return this.clientCA;
  }
  
  public A withClientCA(String clientCA) {
    this.clientCA = clientCA;
    return (A) this;
  }
  
  public boolean hasClientCA() {
    return this.clientCA != null;
  }
  
  public String getKeyFile() {
    return this.keyFile;
  }
  
  public A withKeyFile(String keyFile) {
    this.keyFile = keyFile;
    return (A) this;
  }
  
  public boolean hasKeyFile() {
    return this.keyFile != null;
  }
  
  public String getMinTLSVersion() {
    return this.minTLSVersion;
  }
  
  public A withMinTLSVersion(String minTLSVersion) {
    this.minTLSVersion = minTLSVersion;
    return (A) this;
  }
  
  public boolean hasMinTLSVersion() {
    return this.minTLSVersion != null;
  }
  
  public A addToNamedCertificates(int index,NamedCertificate item) {
    if (this.namedCertificates == null) {this.namedCertificates = new ArrayList<NamedCertificateBuilder>();}
    NamedCertificateBuilder builder = new NamedCertificateBuilder(item);
    if (index < 0 || index >= namedCertificates.size()) { _visitables.get("namedCertificates").add(builder); namedCertificates.add(builder); } else { _visitables.get("namedCertificates").add(index, builder); namedCertificates.add(index, builder);}
    return (A)this;
  }
  
  public A setToNamedCertificates(int index,NamedCertificate item) {
    if (this.namedCertificates == null) {this.namedCertificates = new ArrayList<NamedCertificateBuilder>();}
    NamedCertificateBuilder builder = new NamedCertificateBuilder(item);
    if (index < 0 || index >= namedCertificates.size()) { _visitables.get("namedCertificates").add(builder); namedCertificates.add(builder); } else { _visitables.get("namedCertificates").set(index, builder); namedCertificates.set(index, builder);}
    return (A)this;
  }
  
  public A addToNamedCertificates(io.fabric8.openshift.api.model.config.v1.NamedCertificate... items) {
    if (this.namedCertificates == null) {this.namedCertificates = new ArrayList<NamedCertificateBuilder>();}
    for (NamedCertificate item : items) {NamedCertificateBuilder builder = new NamedCertificateBuilder(item);_visitables.get("namedCertificates").add(builder);this.namedCertificates.add(builder);} return (A)this;
  }
  
  public A addAllToNamedCertificates(Collection<NamedCertificate> items) {
    if (this.namedCertificates == null) {this.namedCertificates = new ArrayList<NamedCertificateBuilder>();}
    for (NamedCertificate item : items) {NamedCertificateBuilder builder = new NamedCertificateBuilder(item);_visitables.get("namedCertificates").add(builder);this.namedCertificates.add(builder);} return (A)this;
  }
  
  public A removeFromNamedCertificates(io.fabric8.openshift.api.model.config.v1.NamedCertificate... items) {
    if (this.namedCertificates == null) return (A)this;
    for (NamedCertificate item : items) {NamedCertificateBuilder builder = new NamedCertificateBuilder(item);_visitables.get("namedCertificates").remove(builder); this.namedCertificates.remove(builder);} return (A)this;
  }
  
  public A removeAllFromNamedCertificates(Collection<NamedCertificate> items) {
    if (this.namedCertificates == null) return (A)this;
    for (NamedCertificate item : items) {NamedCertificateBuilder builder = new NamedCertificateBuilder(item);_visitables.get("namedCertificates").remove(builder); this.namedCertificates.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromNamedCertificates(Predicate<NamedCertificateBuilder> predicate) {
    if (namedCertificates == null) return (A) this;
    final Iterator<NamedCertificateBuilder> each = namedCertificates.iterator();
    final List visitables = _visitables.get("namedCertificates");
    while (each.hasNext()) {
      NamedCertificateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NamedCertificate> buildNamedCertificates() {
    return this.namedCertificates != null ? build(namedCertificates) : null;
  }
  
  public NamedCertificate buildNamedCertificate(int index) {
    return this.namedCertificates.get(index).build();
  }
  
  public NamedCertificate buildFirstNamedCertificate() {
    return this.namedCertificates.get(0).build();
  }
  
  public NamedCertificate buildLastNamedCertificate() {
    return this.namedCertificates.get(namedCertificates.size() - 1).build();
  }
  
  public NamedCertificate buildMatchingNamedCertificate(Predicate<NamedCertificateBuilder> predicate) {
      for (NamedCertificateBuilder item : namedCertificates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingNamedCertificate(Predicate<NamedCertificateBuilder> predicate) {
      for (NamedCertificateBuilder item : namedCertificates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withNamedCertificates(List<NamedCertificate> namedCertificates) {
    if (this.namedCertificates != null) {
      this._visitables.get("namedCertificates").clear();
    }
    if (namedCertificates != null) {
        this.namedCertificates = new ArrayList();
        for (NamedCertificate item : namedCertificates) {
          this.addToNamedCertificates(item);
        }
    } else {
      this.namedCertificates = null;
    }
    return (A) this;
  }
  
  public A withNamedCertificates(io.fabric8.openshift.api.model.config.v1.NamedCertificate... namedCertificates) {
    if (this.namedCertificates != null) {
        this.namedCertificates.clear();
        _visitables.remove("namedCertificates");
    }
    if (namedCertificates != null) {
      for (NamedCertificate item : namedCertificates) {
        this.addToNamedCertificates(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasNamedCertificates() {
    return this.namedCertificates != null && !this.namedCertificates.isEmpty();
  }
  
  public NamedCertificatesNested<A> addNewNamedCertificate() {
    return new NamedCertificatesNested(-1, null);
  }
  
  public NamedCertificatesNested<A> addNewNamedCertificateLike(NamedCertificate item) {
    return new NamedCertificatesNested(-1, item);
  }
  
  public NamedCertificatesNested<A> setNewNamedCertificateLike(int index,NamedCertificate item) {
    return new NamedCertificatesNested(index, item);
  }
  
  public NamedCertificatesNested<A> editNamedCertificate(int index) {
    if (namedCertificates.size() <= index) throw new RuntimeException("Can't edit namedCertificates. Index exceeds size.");
    return setNewNamedCertificateLike(index, buildNamedCertificate(index));
  }
  
  public NamedCertificatesNested<A> editFirstNamedCertificate() {
    if (namedCertificates.size() == 0) throw new RuntimeException("Can't edit first namedCertificates. The list is empty.");
    return setNewNamedCertificateLike(0, buildNamedCertificate(0));
  }
  
  public NamedCertificatesNested<A> editLastNamedCertificate() {
    int index = namedCertificates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last namedCertificates. The list is empty.");
    return setNewNamedCertificateLike(index, buildNamedCertificate(index));
  }
  
  public NamedCertificatesNested<A> editMatchingNamedCertificate(Predicate<NamedCertificateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<namedCertificates.size();i++) { 
    if (predicate.test(namedCertificates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching namedCertificates. No match found.");
    return setNewNamedCertificateLike(index, buildNamedCertificate(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServingInfoFluent that = (ServingInfoFluent) o;
    if (!java.util.Objects.equals(bindAddress, that.bindAddress)) return false;
    if (!java.util.Objects.equals(bindNetwork, that.bindNetwork)) return false;
    if (!java.util.Objects.equals(certFile, that.certFile)) return false;
    if (!java.util.Objects.equals(cipherSuites, that.cipherSuites)) return false;
    if (!java.util.Objects.equals(clientCA, that.clientCA)) return false;
    if (!java.util.Objects.equals(keyFile, that.keyFile)) return false;
    if (!java.util.Objects.equals(minTLSVersion, that.minTLSVersion)) return false;
    if (!java.util.Objects.equals(namedCertificates, that.namedCertificates)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bindAddress,  bindNetwork,  certFile,  cipherSuites,  clientCA,  keyFile,  minTLSVersion,  namedCertificates,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bindAddress != null) { sb.append("bindAddress:"); sb.append(bindAddress + ","); }
    if (bindNetwork != null) { sb.append("bindNetwork:"); sb.append(bindNetwork + ","); }
    if (certFile != null) { sb.append("certFile:"); sb.append(certFile + ","); }
    if (cipherSuites != null && !cipherSuites.isEmpty()) { sb.append("cipherSuites:"); sb.append(cipherSuites + ","); }
    if (clientCA != null) { sb.append("clientCA:"); sb.append(clientCA + ","); }
    if (keyFile != null) { sb.append("keyFile:"); sb.append(keyFile + ","); }
    if (minTLSVersion != null) { sb.append("minTLSVersion:"); sb.append(minTLSVersion + ","); }
    if (namedCertificates != null && !namedCertificates.isEmpty()) { sb.append("namedCertificates:"); sb.append(namedCertificates + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class NamedCertificatesNested<N> extends NamedCertificateFluent<NamedCertificatesNested<N>> implements Nested<N>{
    NamedCertificatesNested(int index,NamedCertificate item) {
      this.index = index;
      this.builder = new NamedCertificateBuilder(this, item);
    }
    NamedCertificateBuilder builder;
    int index;
    
    public N and() {
      return (N) ServingInfoFluent.this.setToNamedCertificates(index,builder.build());
    }
    
    public N endNamedCertificate() {
      return and();
    }
    
  
  }

}