/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.MTUMigration;
import io.fabric8.openshift.api.model.config.v1.MTUMigrationBuilder;
import io.fabric8.openshift.api.model.config.v1.MTUMigrationFluent;
import io.fabric8.openshift.api.model.config.v1.NetworkMigration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NetworkMigrationFluent<A extends NetworkMigrationFluent<A>>
extends BaseFluent<A> {
    private MTUMigrationBuilder mtu;
    private String networkType;
    private Map<String, Object> additionalProperties;

    public NetworkMigrationFluent() {
    }

    public NetworkMigrationFluent(NetworkMigration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkMigration instance) {
        NetworkMigration networkMigration = instance = instance != null ? instance : new NetworkMigration();
        if (instance != null) {
            this.withMtu(instance.getMtu());
            this.withNetworkType(instance.getNetworkType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MTUMigration buildMtu() {
        return this.mtu != null ? this.mtu.build() : null;
    }

    public A withMtu(MTUMigration mtu) {
        this._visitables.remove((Object)"mtu");
        if (mtu != null) {
            this.mtu = new MTUMigrationBuilder(mtu);
            this._visitables.get((Object)"mtu").add(this.mtu);
        } else {
            this.mtu = null;
            this._visitables.get((Object)"mtu").remove((Object)this.mtu);
        }
        return (A)((Object)this);
    }

    public boolean hasMtu() {
        return this.mtu != null;
    }

    public MtuNested<A> withNewMtu() {
        return new MtuNested(null);
    }

    public MtuNested<A> withNewMtuLike(MTUMigration item) {
        return new MtuNested(item);
    }

    public MtuNested<A> editMtu() {
        return this.withNewMtuLike(Optional.ofNullable(this.buildMtu()).orElse(null));
    }

    public MtuNested<A> editOrNewMtu() {
        return this.withNewMtuLike(Optional.ofNullable(this.buildMtu()).orElse(new MTUMigrationBuilder().build()));
    }

    public MtuNested<A> editOrNewMtuLike(MTUMigration item) {
        return this.withNewMtuLike(Optional.ofNullable(this.buildMtu()).orElse(item));
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public A withNetworkType(String networkType) {
        this.networkType = networkType;
        return (A)((Object)this);
    }

    public boolean hasNetworkType() {
        return this.networkType != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkMigrationFluent that = (NetworkMigrationFluent)((Object)o);
        if (!Objects.equals((Object)this.mtu, (Object)that.mtu)) {
            return false;
        }
        if (!Objects.equals(this.networkType, that.networkType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mtu, this.networkType, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mtu != null) {
            sb.append("mtu:");
            sb.append(this.mtu + ",");
        }
        if (this.networkType != null) {
            sb.append("networkType:");
            sb.append(this.networkType + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MtuNested<N>
    extends MTUMigrationFluent<MtuNested<N>>
    implements Nested<N> {
        MTUMigrationBuilder builder;

        MtuNested(MTUMigration item) {
            this.builder = new MTUMigrationBuilder(this, item);
        }

        public N and() {
            return (N)NetworkMigrationFluent.this.withMtu(this.builder.build());
        }

        public N endMtu() {
            return this.and();
        }
    }
}

