package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterVersionStatusFluent<A extends ClusterVersionStatusFluent<A>> extends BaseFluent<A>{
  public ClusterVersionStatusFluent() {
  }
  
  public ClusterVersionStatusFluent(ClusterVersionStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ReleaseBuilder> availableUpdates = new ArrayList<ReleaseBuilder>();
  private ClusterVersionCapabilitiesStatusBuilder capabilities;
  private ArrayList<ConditionalUpdateBuilder> conditionalUpdates = new ArrayList<ConditionalUpdateBuilder>();
  private ArrayList<ClusterOperatorStatusConditionBuilder> conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();
  private ReleaseBuilder desired;
  private ArrayList<UpdateHistoryBuilder> history = new ArrayList<UpdateHistoryBuilder>();
  private Long observedGeneration;
  private String versionHash;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterVersionStatus instance) {
    instance = (instance != null ? instance : new ClusterVersionStatus());
    if (instance != null) {
          this.withAvailableUpdates(instance.getAvailableUpdates());
          this.withCapabilities(instance.getCapabilities());
          this.withConditionalUpdates(instance.getConditionalUpdates());
          this.withConditions(instance.getConditions());
          this.withDesired(instance.getDesired());
          this.withHistory(instance.getHistory());
          this.withObservedGeneration(instance.getObservedGeneration());
          this.withVersionHash(instance.getVersionHash());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAvailableUpdates(int index,Release item) {
    if (this.availableUpdates == null) {this.availableUpdates = new ArrayList<ReleaseBuilder>();}
    ReleaseBuilder builder = new ReleaseBuilder(item);
    if (index < 0 || index >= availableUpdates.size()) {
        _visitables.get("availableUpdates").add(builder);
        availableUpdates.add(builder);
    } else {
        _visitables.get("availableUpdates").add(builder);
        availableUpdates.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToAvailableUpdates(int index,Release item) {
    if (this.availableUpdates == null) {this.availableUpdates = new ArrayList<ReleaseBuilder>();}
    ReleaseBuilder builder = new ReleaseBuilder(item);
    if (index < 0 || index >= availableUpdates.size()) {
        _visitables.get("availableUpdates").add(builder);
        availableUpdates.add(builder);
    } else {
        _visitables.get("availableUpdates").add(builder);
        availableUpdates.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToAvailableUpdates(io.fabric8.openshift.api.model.config.v1.Release... items) {
    if (this.availableUpdates == null) {this.availableUpdates = new ArrayList<ReleaseBuilder>();}
    for (Release item : items) {ReleaseBuilder builder = new ReleaseBuilder(item);_visitables.get("availableUpdates").add(builder);this.availableUpdates.add(builder);} return (A)this;
  }
  
  public A addAllToAvailableUpdates(Collection<Release> items) {
    if (this.availableUpdates == null) {this.availableUpdates = new ArrayList<ReleaseBuilder>();}
    for (Release item : items) {ReleaseBuilder builder = new ReleaseBuilder(item);_visitables.get("availableUpdates").add(builder);this.availableUpdates.add(builder);} return (A)this;
  }
  
  public A removeFromAvailableUpdates(io.fabric8.openshift.api.model.config.v1.Release... items) {
    if (this.availableUpdates == null) return (A)this;
    for (Release item : items) {ReleaseBuilder builder = new ReleaseBuilder(item);_visitables.get("availableUpdates").remove(builder); this.availableUpdates.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAvailableUpdates(Collection<Release> items) {
    if (this.availableUpdates == null) return (A)this;
    for (Release item : items) {ReleaseBuilder builder = new ReleaseBuilder(item);_visitables.get("availableUpdates").remove(builder); this.availableUpdates.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAvailableUpdates(Predicate<ReleaseBuilder> predicate) {
    if (availableUpdates == null) return (A) this;
    final Iterator<ReleaseBuilder> each = availableUpdates.iterator();
    final List visitables = _visitables.get("availableUpdates");
    while (each.hasNext()) {
      ReleaseBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Release> buildAvailableUpdates() {
    return this.availableUpdates != null ? build(availableUpdates) : null;
  }
  
  public Release buildAvailableUpdate(int index) {
    return this.availableUpdates.get(index).build();
  }
  
  public Release buildFirstAvailableUpdate() {
    return this.availableUpdates.get(0).build();
  }
  
  public Release buildLastAvailableUpdate() {
    return this.availableUpdates.get(availableUpdates.size() - 1).build();
  }
  
  public Release buildMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
      for (ReleaseBuilder item : availableUpdates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
      for (ReleaseBuilder item : availableUpdates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAvailableUpdates(List<Release> availableUpdates) {
    if (this.availableUpdates != null) {
      this._visitables.get("availableUpdates").clear();
    }
    if (availableUpdates != null) {
        this.availableUpdates = new ArrayList();
        for (Release item : availableUpdates) {
          this.addToAvailableUpdates(item);
        }
    } else {
      this.availableUpdates = null;
    }
    return (A) this;
  }
  
  public A withAvailableUpdates(io.fabric8.openshift.api.model.config.v1.Release... availableUpdates) {
    if (this.availableUpdates != null) {
        this.availableUpdates.clear();
        _visitables.remove("availableUpdates");
    }
    if (availableUpdates != null) {
      for (Release item : availableUpdates) {
        this.addToAvailableUpdates(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAvailableUpdates() {
    return this.availableUpdates != null && !this.availableUpdates.isEmpty();
  }
  
  public AvailableUpdatesNested<A> addNewAvailableUpdate() {
    return new AvailableUpdatesNested(-1, null);
  }
  
  public AvailableUpdatesNested<A> addNewAvailableUpdateLike(Release item) {
    return new AvailableUpdatesNested(-1, item);
  }
  
  public AvailableUpdatesNested<A> setNewAvailableUpdateLike(int index,Release item) {
    return new AvailableUpdatesNested(index, item);
  }
  
  public AvailableUpdatesNested<A> editAvailableUpdate(int index) {
    if (availableUpdates.size() <= index) throw new RuntimeException("Can't edit availableUpdates. Index exceeds size.");
    return setNewAvailableUpdateLike(index, buildAvailableUpdate(index));
  }
  
  public AvailableUpdatesNested<A> editFirstAvailableUpdate() {
    if (availableUpdates.size() == 0) throw new RuntimeException("Can't edit first availableUpdates. The list is empty.");
    return setNewAvailableUpdateLike(0, buildAvailableUpdate(0));
  }
  
  public AvailableUpdatesNested<A> editLastAvailableUpdate() {
    int index = availableUpdates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last availableUpdates. The list is empty.");
    return setNewAvailableUpdateLike(index, buildAvailableUpdate(index));
  }
  
  public AvailableUpdatesNested<A> editMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
    int index = -1;
    for (int i=0;i<availableUpdates.size();i++) { 
    if (predicate.test(availableUpdates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching availableUpdates. No match found.");
    return setNewAvailableUpdateLike(index, buildAvailableUpdate(index));
  }
  
  public ClusterVersionCapabilitiesStatus buildCapabilities() {
    return this.capabilities != null ? this.capabilities.build() : null;
  }
  
  public A withCapabilities(ClusterVersionCapabilitiesStatus capabilities) {
    this._visitables.remove("capabilities");
    if (capabilities != null) {
        this.capabilities = new ClusterVersionCapabilitiesStatusBuilder(capabilities);
        this._visitables.get("capabilities").add(this.capabilities);
    } else {
        this.capabilities = null;
        this._visitables.get("capabilities").remove(this.capabilities);
    }
    return (A) this;
  }
  
  public boolean hasCapabilities() {
    return this.capabilities != null;
  }
  
  public CapabilitiesNested<A> withNewCapabilities() {
    return new CapabilitiesNested(null);
  }
  
  public CapabilitiesNested<A> withNewCapabilitiesLike(ClusterVersionCapabilitiesStatus item) {
    return new CapabilitiesNested(item);
  }
  
  public CapabilitiesNested<A> editCapabilities() {
    return withNewCapabilitiesLike(java.util.Optional.ofNullable(buildCapabilities()).orElse(null));
  }
  
  public CapabilitiesNested<A> editOrNewCapabilities() {
    return withNewCapabilitiesLike(java.util.Optional.ofNullable(buildCapabilities()).orElse(new ClusterVersionCapabilitiesStatusBuilder().build()));
  }
  
  public CapabilitiesNested<A> editOrNewCapabilitiesLike(ClusterVersionCapabilitiesStatus item) {
    return withNewCapabilitiesLike(java.util.Optional.ofNullable(buildCapabilities()).orElse(item));
  }
  
  public A addToConditionalUpdates(int index,ConditionalUpdate item) {
    if (this.conditionalUpdates == null) {this.conditionalUpdates = new ArrayList<ConditionalUpdateBuilder>();}
    ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
    if (index < 0 || index >= conditionalUpdates.size()) {
        _visitables.get("conditionalUpdates").add(builder);
        conditionalUpdates.add(builder);
    } else {
        _visitables.get("conditionalUpdates").add(builder);
        conditionalUpdates.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToConditionalUpdates(int index,ConditionalUpdate item) {
    if (this.conditionalUpdates == null) {this.conditionalUpdates = new ArrayList<ConditionalUpdateBuilder>();}
    ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
    if (index < 0 || index >= conditionalUpdates.size()) {
        _visitables.get("conditionalUpdates").add(builder);
        conditionalUpdates.add(builder);
    } else {
        _visitables.get("conditionalUpdates").add(builder);
        conditionalUpdates.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToConditionalUpdates(io.fabric8.openshift.api.model.config.v1.ConditionalUpdate... items) {
    if (this.conditionalUpdates == null) {this.conditionalUpdates = new ArrayList<ConditionalUpdateBuilder>();}
    for (ConditionalUpdate item : items) {ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);_visitables.get("conditionalUpdates").add(builder);this.conditionalUpdates.add(builder);} return (A)this;
  }
  
  public A addAllToConditionalUpdates(Collection<ConditionalUpdate> items) {
    if (this.conditionalUpdates == null) {this.conditionalUpdates = new ArrayList<ConditionalUpdateBuilder>();}
    for (ConditionalUpdate item : items) {ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);_visitables.get("conditionalUpdates").add(builder);this.conditionalUpdates.add(builder);} return (A)this;
  }
  
  public A removeFromConditionalUpdates(io.fabric8.openshift.api.model.config.v1.ConditionalUpdate... items) {
    if (this.conditionalUpdates == null) return (A)this;
    for (ConditionalUpdate item : items) {ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);_visitables.get("conditionalUpdates").remove(builder); this.conditionalUpdates.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditionalUpdates(Collection<ConditionalUpdate> items) {
    if (this.conditionalUpdates == null) return (A)this;
    for (ConditionalUpdate item : items) {ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);_visitables.get("conditionalUpdates").remove(builder); this.conditionalUpdates.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditionalUpdates(Predicate<ConditionalUpdateBuilder> predicate) {
    if (conditionalUpdates == null) return (A) this;
    final Iterator<ConditionalUpdateBuilder> each = conditionalUpdates.iterator();
    final List visitables = _visitables.get("conditionalUpdates");
    while (each.hasNext()) {
      ConditionalUpdateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ConditionalUpdate> buildConditionalUpdates() {
    return this.conditionalUpdates != null ? build(conditionalUpdates) : null;
  }
  
  public ConditionalUpdate buildConditionalUpdate(int index) {
    return this.conditionalUpdates.get(index).build();
  }
  
  public ConditionalUpdate buildFirstConditionalUpdate() {
    return this.conditionalUpdates.get(0).build();
  }
  
  public ConditionalUpdate buildLastConditionalUpdate() {
    return this.conditionalUpdates.get(conditionalUpdates.size() - 1).build();
  }
  
  public ConditionalUpdate buildMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate) {
      for (ConditionalUpdateBuilder item : conditionalUpdates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate) {
      for (ConditionalUpdateBuilder item : conditionalUpdates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditionalUpdates(List<ConditionalUpdate> conditionalUpdates) {
    if (this.conditionalUpdates != null) {
      this._visitables.get("conditionalUpdates").clear();
    }
    if (conditionalUpdates != null) {
        this.conditionalUpdates = new ArrayList();
        for (ConditionalUpdate item : conditionalUpdates) {
          this.addToConditionalUpdates(item);
        }
    } else {
      this.conditionalUpdates = null;
    }
    return (A) this;
  }
  
  public A withConditionalUpdates(io.fabric8.openshift.api.model.config.v1.ConditionalUpdate... conditionalUpdates) {
    if (this.conditionalUpdates != null) {
        this.conditionalUpdates.clear();
        _visitables.remove("conditionalUpdates");
    }
    if (conditionalUpdates != null) {
      for (ConditionalUpdate item : conditionalUpdates) {
        this.addToConditionalUpdates(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditionalUpdates() {
    return this.conditionalUpdates != null && !this.conditionalUpdates.isEmpty();
  }
  
  public ConditionalUpdatesNested<A> addNewConditionalUpdate() {
    return new ConditionalUpdatesNested(-1, null);
  }
  
  public ConditionalUpdatesNested<A> addNewConditionalUpdateLike(ConditionalUpdate item) {
    return new ConditionalUpdatesNested(-1, item);
  }
  
  public ConditionalUpdatesNested<A> setNewConditionalUpdateLike(int index,ConditionalUpdate item) {
    return new ConditionalUpdatesNested(index, item);
  }
  
  public ConditionalUpdatesNested<A> editConditionalUpdate(int index) {
    if (conditionalUpdates.size() <= index) throw new RuntimeException("Can't edit conditionalUpdates. Index exceeds size.");
    return setNewConditionalUpdateLike(index, buildConditionalUpdate(index));
  }
  
  public ConditionalUpdatesNested<A> editFirstConditionalUpdate() {
    if (conditionalUpdates.size() == 0) throw new RuntimeException("Can't edit first conditionalUpdates. The list is empty.");
    return setNewConditionalUpdateLike(0, buildConditionalUpdate(0));
  }
  
  public ConditionalUpdatesNested<A> editLastConditionalUpdate() {
    int index = conditionalUpdates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditionalUpdates. The list is empty.");
    return setNewConditionalUpdateLike(index, buildConditionalUpdate(index));
  }
  
  public ConditionalUpdatesNested<A> editMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditionalUpdates.size();i++) { 
    if (predicate.test(conditionalUpdates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditionalUpdates. No match found.");
    return setNewConditionalUpdateLike(index, buildConditionalUpdate(index));
  }
  
  public A addToConditions(int index,ClusterOperatorStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) {
        _visitables.get("conditions").add(builder);
        conditions.add(builder);
    } else {
        _visitables.get("conditions").add(builder);
        conditions.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToConditions(int index,ClusterOperatorStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) {
        _visitables.get("conditions").add(builder);
        conditions.add(builder);
    } else {
        _visitables.get("conditions").add(builder);
        conditions.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... items) {
    if (this.conditions == null) return (A)this;
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items) {
    if (this.conditions == null) return (A)this;
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ClusterOperatorStatusConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ClusterOperatorStatusConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ClusterOperatorStatusCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public ClusterOperatorStatusCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public ClusterOperatorStatusCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public ClusterOperatorStatusCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public ClusterOperatorStatusCondition buildMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
      for (ClusterOperatorStatusConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
      for (ClusterOperatorStatusConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<ClusterOperatorStatusCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (ClusterOperatorStatusCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (ClusterOperatorStatusCondition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ClusterOperatorStatusCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(ClusterOperatorStatusCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,ClusterOperatorStatusCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public Release buildDesired() {
    return this.desired != null ? this.desired.build() : null;
  }
  
  public A withDesired(Release desired) {
    this._visitables.remove("desired");
    if (desired != null) {
        this.desired = new ReleaseBuilder(desired);
        this._visitables.get("desired").add(this.desired);
    } else {
        this.desired = null;
        this._visitables.get("desired").remove(this.desired);
    }
    return (A) this;
  }
  
  public boolean hasDesired() {
    return this.desired != null;
  }
  
  public DesiredNested<A> withNewDesired() {
    return new DesiredNested(null);
  }
  
  public DesiredNested<A> withNewDesiredLike(Release item) {
    return new DesiredNested(item);
  }
  
  public DesiredNested<A> editDesired() {
    return withNewDesiredLike(java.util.Optional.ofNullable(buildDesired()).orElse(null));
  }
  
  public DesiredNested<A> editOrNewDesired() {
    return withNewDesiredLike(java.util.Optional.ofNullable(buildDesired()).orElse(new ReleaseBuilder().build()));
  }
  
  public DesiredNested<A> editOrNewDesiredLike(Release item) {
    return withNewDesiredLike(java.util.Optional.ofNullable(buildDesired()).orElse(item));
  }
  
  public A addToHistory(int index,UpdateHistory item) {
    if (this.history == null) {this.history = new ArrayList<UpdateHistoryBuilder>();}
    UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
    if (index < 0 || index >= history.size()) {
        _visitables.get("history").add(builder);
        history.add(builder);
    } else {
        _visitables.get("history").add(builder);
        history.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToHistory(int index,UpdateHistory item) {
    if (this.history == null) {this.history = new ArrayList<UpdateHistoryBuilder>();}
    UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
    if (index < 0 || index >= history.size()) {
        _visitables.get("history").add(builder);
        history.add(builder);
    } else {
        _visitables.get("history").add(builder);
        history.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToHistory(io.fabric8.openshift.api.model.config.v1.UpdateHistory... items) {
    if (this.history == null) {this.history = new ArrayList<UpdateHistoryBuilder>();}
    for (UpdateHistory item : items) {UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);_visitables.get("history").add(builder);this.history.add(builder);} return (A)this;
  }
  
  public A addAllToHistory(Collection<UpdateHistory> items) {
    if (this.history == null) {this.history = new ArrayList<UpdateHistoryBuilder>();}
    for (UpdateHistory item : items) {UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);_visitables.get("history").add(builder);this.history.add(builder);} return (A)this;
  }
  
  public A removeFromHistory(io.fabric8.openshift.api.model.config.v1.UpdateHistory... items) {
    if (this.history == null) return (A)this;
    for (UpdateHistory item : items) {UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);_visitables.get("history").remove(builder); this.history.remove(builder);} return (A)this;
  }
  
  public A removeAllFromHistory(Collection<UpdateHistory> items) {
    if (this.history == null) return (A)this;
    for (UpdateHistory item : items) {UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);_visitables.get("history").remove(builder); this.history.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromHistory(Predicate<UpdateHistoryBuilder> predicate) {
    if (history == null) return (A) this;
    final Iterator<UpdateHistoryBuilder> each = history.iterator();
    final List visitables = _visitables.get("history");
    while (each.hasNext()) {
      UpdateHistoryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<UpdateHistory> buildHistory() {
    return this.history != null ? build(history) : null;
  }
  
  public UpdateHistory buildHistory(int index) {
    return this.history.get(index).build();
  }
  
  public UpdateHistory buildFirstHistory() {
    return this.history.get(0).build();
  }
  
  public UpdateHistory buildLastHistory() {
    return this.history.get(history.size() - 1).build();
  }
  
  public UpdateHistory buildMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
      for (UpdateHistoryBuilder item : history) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
      for (UpdateHistoryBuilder item : history) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withHistory(List<UpdateHistory> history) {
    if (this.history != null) {
      this._visitables.get("history").clear();
    }
    if (history != null) {
        this.history = new ArrayList();
        for (UpdateHistory item : history) {
          this.addToHistory(item);
        }
    } else {
      this.history = null;
    }
    return (A) this;
  }
  
  public A withHistory(io.fabric8.openshift.api.model.config.v1.UpdateHistory... history) {
    if (this.history != null) {
        this.history.clear();
        _visitables.remove("history");
    }
    if (history != null) {
      for (UpdateHistory item : history) {
        this.addToHistory(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasHistory() {
    return this.history != null && !this.history.isEmpty();
  }
  
  public HistoryNested<A> addNewHistory() {
    return new HistoryNested(-1, null);
  }
  
  public HistoryNested<A> addNewHistoryLike(UpdateHistory item) {
    return new HistoryNested(-1, item);
  }
  
  public HistoryNested<A> setNewHistoryLike(int index,UpdateHistory item) {
    return new HistoryNested(index, item);
  }
  
  public HistoryNested<A> editHistory(int index) {
    if (history.size() <= index) throw new RuntimeException("Can't edit history. Index exceeds size.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  
  public HistoryNested<A> editFirstHistory() {
    if (history.size() == 0) throw new RuntimeException("Can't edit first history. The list is empty.");
    return setNewHistoryLike(0, buildHistory(0));
  }
  
  public HistoryNested<A> editLastHistory() {
    int index = history.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last history. The list is empty.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  
  public HistoryNested<A> editMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<history.size();i++) { 
    if (predicate.test(history.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching history. No match found.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration = observedGeneration;
    return (A) this;
  }
  
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  
  public String getVersionHash() {
    return this.versionHash;
  }
  
  public A withVersionHash(String versionHash) {
    this.versionHash = versionHash;
    return (A) this;
  }
  
  public boolean hasVersionHash() {
    return this.versionHash != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterVersionStatusFluent that = (ClusterVersionStatusFluent) o;
    if (!java.util.Objects.equals(availableUpdates, that.availableUpdates)) return false;
    if (!java.util.Objects.equals(capabilities, that.capabilities)) return false;
    if (!java.util.Objects.equals(conditionalUpdates, that.conditionalUpdates)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(desired, that.desired)) return false;
    if (!java.util.Objects.equals(history, that.history)) return false;
    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;
    if (!java.util.Objects.equals(versionHash, that.versionHash)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(availableUpdates,  capabilities,  conditionalUpdates,  conditions,  desired,  history,  observedGeneration,  versionHash,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (availableUpdates != null && !availableUpdates.isEmpty()) { sb.append("availableUpdates:"); sb.append(availableUpdates + ","); }
    if (capabilities != null) { sb.append("capabilities:"); sb.append(capabilities + ","); }
    if (conditionalUpdates != null && !conditionalUpdates.isEmpty()) { sb.append("conditionalUpdates:"); sb.append(conditionalUpdates + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (desired != null) { sb.append("desired:"); sb.append(desired + ","); }
    if (history != null && !history.isEmpty()) { sb.append("history:"); sb.append(history + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (versionHash != null) { sb.append("versionHash:"); sb.append(versionHash + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AvailableUpdatesNested<N> extends ReleaseFluent<AvailableUpdatesNested<N>> implements Nested<N>{
    AvailableUpdatesNested(int index,Release item) {
      this.index = index;
      this.builder = new ReleaseBuilder(this, item);
    }
    ReleaseBuilder builder;
    int index;
    
    public N and() {
      return (N) ClusterVersionStatusFluent.this.setToAvailableUpdates(index,builder.build());
    }
    
    public N endAvailableUpdate() {
      return and();
    }
    
  
  }
  public class CapabilitiesNested<N> extends ClusterVersionCapabilitiesStatusFluent<CapabilitiesNested<N>> implements Nested<N>{
    CapabilitiesNested(ClusterVersionCapabilitiesStatus item) {
      this.builder = new ClusterVersionCapabilitiesStatusBuilder(this, item);
    }
    ClusterVersionCapabilitiesStatusBuilder builder;
    
    public N and() {
      return (N) ClusterVersionStatusFluent.this.withCapabilities(builder.build());
    }
    
    public N endCapabilities() {
      return and();
    }
    
  
  }
  public class ConditionalUpdatesNested<N> extends ConditionalUpdateFluent<ConditionalUpdatesNested<N>> implements Nested<N>{
    ConditionalUpdatesNested(int index,ConditionalUpdate item) {
      this.index = index;
      this.builder = new ConditionalUpdateBuilder(this, item);
    }
    ConditionalUpdateBuilder builder;
    int index;
    
    public N and() {
      return (N) ClusterVersionStatusFluent.this.setToConditionalUpdates(index,builder.build());
    }
    
    public N endConditionalUpdate() {
      return and();
    }
    
  
  }
  public class ConditionsNested<N> extends ClusterOperatorStatusConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,ClusterOperatorStatusCondition item) {
      this.index = index;
      this.builder = new ClusterOperatorStatusConditionBuilder(this, item);
    }
    ClusterOperatorStatusConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) ClusterVersionStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class DesiredNested<N> extends ReleaseFluent<DesiredNested<N>> implements Nested<N>{
    DesiredNested(Release item) {
      this.builder = new ReleaseBuilder(this, item);
    }
    ReleaseBuilder builder;
    
    public N and() {
      return (N) ClusterVersionStatusFluent.this.withDesired(builder.build());
    }
    
    public N endDesired() {
      return and();
    }
    
  
  }
  public class HistoryNested<N> extends UpdateHistoryFluent<HistoryNested<N>> implements Nested<N>{
    HistoryNested(int index,UpdateHistory item) {
      this.index = index;
      this.builder = new UpdateHistoryBuilder(this, item);
    }
    UpdateHistoryBuilder builder;
    int index;
    
    public N and() {
      return (N) ClusterVersionStatusFluent.this.setToHistory(index,builder.build());
    }
    
    public N endHistory() {
      return and();
    }
    
  
  }

}