package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EtcdStorageConfigBuilder extends EtcdStorageConfigFluent<EtcdStorageConfigBuilder> implements VisitableBuilder<EtcdStorageConfig,EtcdStorageConfigBuilder>{
  public EtcdStorageConfigBuilder() {
    this(new EtcdStorageConfig());
  }
  
  public EtcdStorageConfigBuilder(EtcdStorageConfigFluent<?> fluent) {
    this(fluent, new EtcdStorageConfig());
  }
  
  public EtcdStorageConfigBuilder(EtcdStorageConfigFluent<?> fluent,EtcdStorageConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EtcdStorageConfigBuilder(EtcdStorageConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EtcdStorageConfigFluent<?> fluent;
  
  public EtcdStorageConfig build() {
    EtcdStorageConfig buildable = new EtcdStorageConfig(fluent.getCa(),fluent.getCertFile(),fluent.getKeyFile(),fluent.getStoragePrefix(),fluent.getUrls());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}