
package io.fabric8.openshift.api.model.config.v1;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * InfrastructureSpec contains settings that apply to the cluster infrastructure.
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "cloudConfig",
    "platformSpec"
})
@ToString
@EqualsAndHashCode
@Accessors(prefix = {
    "_",
    ""
})
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
@Generated("io.fabric8.kubernetes.schema.generator.model.ModelGenerator")
public class InfrastructureSpec implements Editable<InfrastructureSpecBuilder>, KubernetesResource
{

    @JsonProperty("cloudConfig")
    private ConfigMapFileReference cloudConfig;
    @JsonProperty("platformSpec")
    private PlatformSpec platformSpec;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     */
    public InfrastructureSpec() {
    }

    public InfrastructureSpec(ConfigMapFileReference cloudConfig, PlatformSpec platformSpec) {
        super();
        this.cloudConfig = cloudConfig;
        this.platformSpec = platformSpec;
    }

    /**
     * InfrastructureSpec contains settings that apply to the cluster infrastructure.
     */
    @JsonProperty("cloudConfig")
    public ConfigMapFileReference getCloudConfig() {
        return cloudConfig;
    }

    /**
     * InfrastructureSpec contains settings that apply to the cluster infrastructure.
     */
    @JsonProperty("cloudConfig")
    public void setCloudConfig(ConfigMapFileReference cloudConfig) {
        this.cloudConfig = cloudConfig;
    }

    /**
     * InfrastructureSpec contains settings that apply to the cluster infrastructure.
     */
    @JsonProperty("platformSpec")
    public PlatformSpec getPlatformSpec() {
        return platformSpec;
    }

    /**
     * InfrastructureSpec contains settings that apply to the cluster infrastructure.
     */
    @JsonProperty("platformSpec")
    public void setPlatformSpec(PlatformSpec platformSpec) {
        this.platformSpec = platformSpec;
    }

    @JsonIgnore
    public InfrastructureSpecBuilder edit() {
        return new InfrastructureSpecBuilder(this);
    }

    @JsonIgnore
    public InfrastructureSpecBuilder toBuilder() {
        return edit();
    }

    @JsonAnyGetter
    @JsonIgnore
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

}
