package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TokenIssuerFluent<A extends TokenIssuerFluent<A>> extends BaseFluent<A>{
  public TokenIssuerFluent() {
  }
  
  public TokenIssuerFluent(TokenIssuer instance) {
    this.copyInstance(instance);
  }
  private List<String> audiences = new ArrayList<String>();
  private ConfigMapNameReferenceBuilder issuerCertificateAuthority;
  private String issuerURL;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TokenIssuer instance) {
    instance = (instance != null ? instance : new TokenIssuer());
    if (instance != null) {
          this.withAudiences(instance.getAudiences());
          this.withIssuerCertificateAuthority(instance.getIssuerCertificateAuthority());
          this.withIssuerURL(instance.getIssuerURL());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAudiences(int index,String item) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    this.audiences.add(index, item);
    return (A)this;
  }
  
  public A setToAudiences(int index,String item) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    this.audiences.set(index, item); return (A)this;
  }
  
  public A addToAudiences(java.lang.String... items) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    for (String item : items) {this.audiences.add(item);} return (A)this;
  }
  
  public A addAllToAudiences(Collection<String> items) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    for (String item : items) {this.audiences.add(item);} return (A)this;
  }
  
  public A removeFromAudiences(java.lang.String... items) {
    if (this.audiences == null) return (A)this;
    for (String item : items) { this.audiences.remove(item);} return (A)this;
  }
  
  public A removeAllFromAudiences(Collection<String> items) {
    if (this.audiences == null) return (A)this;
    for (String item : items) { this.audiences.remove(item);} return (A)this;
  }
  
  public List<String> getAudiences() {
    return this.audiences;
  }
  
  public String getAudience(int index) {
    return this.audiences.get(index);
  }
  
  public String getFirstAudience() {
    return this.audiences.get(0);
  }
  
  public String getLastAudience() {
    return this.audiences.get(audiences.size() - 1);
  }
  
  public String getMatchingAudience(Predicate<String> predicate) {
      for (String item : audiences) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAudience(Predicate<String> predicate) {
      for (String item : audiences) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAudiences(List<String> audiences) {
    if (audiences != null) {
        this.audiences = new ArrayList();
        for (String item : audiences) {
          this.addToAudiences(item);
        }
    } else {
      this.audiences = null;
    }
    return (A) this;
  }
  
  public A withAudiences(java.lang.String... audiences) {
    if (this.audiences != null) {
        this.audiences.clear();
        _visitables.remove("audiences");
    }
    if (audiences != null) {
      for (String item : audiences) {
        this.addToAudiences(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAudiences() {
    return this.audiences != null && !this.audiences.isEmpty();
  }
  
  public ConfigMapNameReference buildIssuerCertificateAuthority() {
    return this.issuerCertificateAuthority != null ? this.issuerCertificateAuthority.build() : null;
  }
  
  public A withIssuerCertificateAuthority(ConfigMapNameReference issuerCertificateAuthority) {
    this._visitables.remove("issuerCertificateAuthority");
    if (issuerCertificateAuthority != null) {
        this.issuerCertificateAuthority = new ConfigMapNameReferenceBuilder(issuerCertificateAuthority);
        this._visitables.get("issuerCertificateAuthority").add(this.issuerCertificateAuthority);
    } else {
        this.issuerCertificateAuthority = null;
        this._visitables.get("issuerCertificateAuthority").remove(this.issuerCertificateAuthority);
    }
    return (A) this;
  }
  
  public boolean hasIssuerCertificateAuthority() {
    return this.issuerCertificateAuthority != null;
  }
  
  public A withNewIssuerCertificateAuthority(String name) {
    return (A)withIssuerCertificateAuthority(new ConfigMapNameReference(name));
  }
  
  public IssuerCertificateAuthorityNested<A> withNewIssuerCertificateAuthority() {
    return new IssuerCertificateAuthorityNested(null);
  }
  
  public IssuerCertificateAuthorityNested<A> withNewIssuerCertificateAuthorityLike(ConfigMapNameReference item) {
    return new IssuerCertificateAuthorityNested(item);
  }
  
  public IssuerCertificateAuthorityNested<A> editIssuerCertificateAuthority() {
    return withNewIssuerCertificateAuthorityLike(java.util.Optional.ofNullable(buildIssuerCertificateAuthority()).orElse(null));
  }
  
  public IssuerCertificateAuthorityNested<A> editOrNewIssuerCertificateAuthority() {
    return withNewIssuerCertificateAuthorityLike(java.util.Optional.ofNullable(buildIssuerCertificateAuthority()).orElse(new ConfigMapNameReferenceBuilder().build()));
  }
  
  public IssuerCertificateAuthorityNested<A> editOrNewIssuerCertificateAuthorityLike(ConfigMapNameReference item) {
    return withNewIssuerCertificateAuthorityLike(java.util.Optional.ofNullable(buildIssuerCertificateAuthority()).orElse(item));
  }
  
  public String getIssuerURL() {
    return this.issuerURL;
  }
  
  public A withIssuerURL(String issuerURL) {
    this.issuerURL = issuerURL;
    return (A) this;
  }
  
  public boolean hasIssuerURL() {
    return this.issuerURL != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TokenIssuerFluent that = (TokenIssuerFluent) o;
    if (!java.util.Objects.equals(audiences, that.audiences)) return false;
    if (!java.util.Objects.equals(issuerCertificateAuthority, that.issuerCertificateAuthority)) return false;
    if (!java.util.Objects.equals(issuerURL, that.issuerURL)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(audiences,  issuerCertificateAuthority,  issuerURL,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (audiences != null && !audiences.isEmpty()) { sb.append("audiences:"); sb.append(audiences + ","); }
    if (issuerCertificateAuthority != null) { sb.append("issuerCertificateAuthority:"); sb.append(issuerCertificateAuthority + ","); }
    if (issuerURL != null) { sb.append("issuerURL:"); sb.append(issuerURL + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class IssuerCertificateAuthorityNested<N> extends ConfigMapNameReferenceFluent<IssuerCertificateAuthorityNested<N>> implements Nested<N>{
    IssuerCertificateAuthorityNested(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    ConfigMapNameReferenceBuilder builder;
    
    public N and() {
      return (N) TokenIssuerFluent.this.withIssuerCertificateAuthority(builder.build());
    }
    
    public N endIssuerCertificateAuthority() {
      return and();
    }
    
  
  }

}