/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ExtraMapping;
import io.fabric8.openshift.api.model.config.v1.ExtraMappingBuilder;
import io.fabric8.openshift.api.model.config.v1.ExtraMappingFluent;
import io.fabric8.openshift.api.model.config.v1.PrefixedClaimMapping;
import io.fabric8.openshift.api.model.config.v1.PrefixedClaimMappingBuilder;
import io.fabric8.openshift.api.model.config.v1.PrefixedClaimMappingFluent;
import io.fabric8.openshift.api.model.config.v1.TokenClaimMappings;
import io.fabric8.openshift.api.model.config.v1.TokenClaimOrExpressionMapping;
import io.fabric8.openshift.api.model.config.v1.TokenClaimOrExpressionMappingBuilder;
import io.fabric8.openshift.api.model.config.v1.TokenClaimOrExpressionMappingFluent;
import io.fabric8.openshift.api.model.config.v1.UsernameClaimMapping;
import io.fabric8.openshift.api.model.config.v1.UsernameClaimMappingBuilder;
import io.fabric8.openshift.api.model.config.v1.UsernameClaimMappingFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TokenClaimMappingsFluent<A extends TokenClaimMappingsFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<ExtraMappingBuilder> extra = new ArrayList();
    private PrefixedClaimMappingBuilder groups;
    private TokenClaimOrExpressionMappingBuilder uid;
    private UsernameClaimMappingBuilder username;

    public TokenClaimMappingsFluent() {
    }

    public TokenClaimMappingsFluent(TokenClaimMappings instance) {
        this.copyInstance(instance);
    }

    public A addAllToExtra(Collection<ExtraMapping> items) {
        if (this.extra == null) {
            this.extra = new ArrayList();
        }
        for (ExtraMapping item : items) {
            ExtraMappingBuilder builder = new ExtraMappingBuilder(item);
            this._visitables.get((Object)"extra").add(builder);
            this.extra.add(builder);
        }
        return (A)((Object)this);
    }

    public ExtraNested<A> addNewExtra() {
        return new ExtraNested(-1, null);
    }

    public A addNewExtra(String key, String valueExpression) {
        return this.addToExtra(new ExtraMapping(key, valueExpression));
    }

    public ExtraNested<A> addNewExtraLike(ExtraMapping item) {
        return new ExtraNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToExtra(ExtraMapping ... items) {
        if (this.extra == null) {
            this.extra = new ArrayList();
        }
        for (ExtraMapping item : items) {
            ExtraMappingBuilder builder = new ExtraMappingBuilder(item);
            this._visitables.get((Object)"extra").add(builder);
            this.extra.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToExtra(int index, ExtraMapping item) {
        if (this.extra == null) {
            this.extra = new ArrayList();
        }
        ExtraMappingBuilder builder = new ExtraMappingBuilder(item);
        if (index < 0 || index >= this.extra.size()) {
            this._visitables.get((Object)"extra").add(builder);
            this.extra.add(builder);
        } else {
            this._visitables.get((Object)"extra").add(builder);
            this.extra.add(index, builder);
        }
        return (A)((Object)this);
    }

    public List<ExtraMapping> buildExtra() {
        return this.extra != null ? TokenClaimMappingsFluent.build(this.extra) : null;
    }

    public ExtraMapping buildExtra(int index) {
        return this.extra.get(index).build();
    }

    public ExtraMapping buildFirstExtra() {
        return this.extra.get(0).build();
    }

    public PrefixedClaimMapping buildGroups() {
        return this.groups != null ? this.groups.build() : null;
    }

    public ExtraMapping buildLastExtra() {
        return this.extra.get(this.extra.size() - 1).build();
    }

    public ExtraMapping buildMatchingExtra(Predicate<ExtraMappingBuilder> predicate) {
        for (ExtraMappingBuilder item : this.extra) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public TokenClaimOrExpressionMapping buildUid() {
        return this.uid != null ? this.uid.build() : null;
    }

    public UsernameClaimMapping buildUsername() {
        return this.username != null ? this.username.build() : null;
    }

    protected void copyInstance(TokenClaimMappings instance) {
        TokenClaimMappings tokenClaimMappings = instance = instance != null ? instance : new TokenClaimMappings();
        if (instance != null) {
            this.withExtra(instance.getExtra());
            this.withGroups(instance.getGroups());
            this.withUid(instance.getUid());
            this.withUsername(instance.getUsername());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ExtraNested<A> editExtra(int index) {
        if (this.extra.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "extra"));
        }
        return this.setNewExtraLike(index, this.buildExtra(index));
    }

    public ExtraNested<A> editFirstExtra() {
        if (this.extra.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "extra"));
        }
        return this.setNewExtraLike(0, this.buildExtra(0));
    }

    public GroupsNested<A> editGroups() {
        return this.withNewGroupsLike(Optional.ofNullable(this.buildGroups()).orElse(null));
    }

    public ExtraNested<A> editLastExtra() {
        int index = this.extra.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "extra"));
        }
        return this.setNewExtraLike(index, this.buildExtra(index));
    }

    public ExtraNested<A> editMatchingExtra(Predicate<ExtraMappingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extra.size(); ++i) {
            if (!predicate.test(this.extra.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "extra"));
        }
        return this.setNewExtraLike(index, this.buildExtra(index));
    }

    public GroupsNested<A> editOrNewGroups() {
        return this.withNewGroupsLike(Optional.ofNullable(this.buildGroups()).orElse(new PrefixedClaimMappingBuilder().build()));
    }

    public GroupsNested<A> editOrNewGroupsLike(PrefixedClaimMapping item) {
        return this.withNewGroupsLike(Optional.ofNullable(this.buildGroups()).orElse(item));
    }

    public UidNested<A> editOrNewUid() {
        return this.withNewUidLike(Optional.ofNullable(this.buildUid()).orElse(new TokenClaimOrExpressionMappingBuilder().build()));
    }

    public UidNested<A> editOrNewUidLike(TokenClaimOrExpressionMapping item) {
        return this.withNewUidLike(Optional.ofNullable(this.buildUid()).orElse(item));
    }

    public UsernameNested<A> editOrNewUsername() {
        return this.withNewUsernameLike(Optional.ofNullable(this.buildUsername()).orElse(new UsernameClaimMappingBuilder().build()));
    }

    public UsernameNested<A> editOrNewUsernameLike(UsernameClaimMapping item) {
        return this.withNewUsernameLike(Optional.ofNullable(this.buildUsername()).orElse(item));
    }

    public UidNested<A> editUid() {
        return this.withNewUidLike(Optional.ofNullable(this.buildUid()).orElse(null));
    }

    public UsernameNested<A> editUsername() {
        return this.withNewUsernameLike(Optional.ofNullable(this.buildUsername()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenClaimMappingsFluent that = (TokenClaimMappingsFluent)((Object)o);
        if (!Objects.equals(this.extra, that.extra)) {
            return false;
        }
        if (!Objects.equals((Object)this.groups, (Object)that.groups)) {
            return false;
        }
        if (!Objects.equals((Object)this.uid, (Object)that.uid)) {
            return false;
        }
        if (!Objects.equals((Object)this.username, (Object)that.username)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasExtra() {
        return this.extra != null && !this.extra.isEmpty();
    }

    public boolean hasGroups() {
        return this.groups != null;
    }

    public boolean hasMatchingExtra(Predicate<ExtraMappingBuilder> predicate) {
        for (ExtraMappingBuilder item : this.extra) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.extra, this.groups, this.uid, this.username, this.additionalProperties});
    }

    public A removeAllFromExtra(Collection<ExtraMapping> items) {
        if (this.extra == null) {
            return (A)((Object)this);
        }
        for (ExtraMapping item : items) {
            ExtraMappingBuilder builder = new ExtraMappingBuilder(item);
            this._visitables.get((Object)"extra").remove((Object)builder);
            this.extra.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromExtra(ExtraMapping ... items) {
        if (this.extra == null) {
            return (A)((Object)this);
        }
        for (ExtraMapping item : items) {
            ExtraMappingBuilder builder = new ExtraMappingBuilder(item);
            this._visitables.get((Object)"extra").remove((Object)builder);
            this.extra.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromExtra(Predicate<ExtraMappingBuilder> predicate) {
        if (this.extra == null) {
            return (A)((Object)this);
        }
        Iterator<ExtraMappingBuilder> each = this.extra.iterator();
        List visitables = this._visitables.get((Object)"extra");
        while (each.hasNext()) {
            ExtraMappingBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ExtraNested<A> setNewExtraLike(int index, ExtraMapping item) {
        return new ExtraNested(index, item);
    }

    public A setToExtra(int index, ExtraMapping item) {
        if (this.extra == null) {
            this.extra = new ArrayList();
        }
        ExtraMappingBuilder builder = new ExtraMappingBuilder(item);
        if (index < 0 || index >= this.extra.size()) {
            this._visitables.get((Object)"extra").add(builder);
            this.extra.add(builder);
        } else {
            this._visitables.get((Object)"extra").add(builder);
            this.extra.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.extra != null && !this.extra.isEmpty()) {
            sb.append("extra:");
            sb.append(this.extra);
            sb.append(",");
        }
        if (this.groups != null) {
            sb.append("groups:");
            sb.append((Object)this.groups);
            sb.append(",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append((Object)this.uid);
            sb.append(",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append((Object)this.username);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withExtra(List<ExtraMapping> extra) {
        if (this.extra != null) {
            this._visitables.get((Object)"extra").clear();
        }
        if (extra != null) {
            this.extra = new ArrayList();
            for (ExtraMapping item : extra) {
                this.addToExtra(item);
            }
        } else {
            this.extra = null;
        }
        return (A)((Object)this);
    }

    public A withExtra(ExtraMapping ... extra) {
        if (this.extra != null) {
            this.extra.clear();
            this._visitables.remove((Object)"extra");
        }
        if (extra != null) {
            for (ExtraMapping item : extra) {
                this.addToExtra(item);
            }
        }
        return (A)((Object)this);
    }

    public A withGroups(PrefixedClaimMapping groups) {
        this._visitables.remove((Object)"groups");
        if (groups != null) {
            this.groups = new PrefixedClaimMappingBuilder(groups);
            this._visitables.get((Object)"groups").add(this.groups);
        } else {
            this.groups = null;
            this._visitables.get((Object)"groups").remove((Object)this.groups);
        }
        return (A)((Object)this);
    }

    public GroupsNested<A> withNewGroups() {
        return new GroupsNested(null);
    }

    public A withNewGroups(String claim, String prefix) {
        return this.withGroups(new PrefixedClaimMapping(claim, prefix));
    }

    public GroupsNested<A> withNewGroupsLike(PrefixedClaimMapping item) {
        return new GroupsNested(item);
    }

    public UidNested<A> withNewUid() {
        return new UidNested(null);
    }

    public A withNewUid(String claim, String expression) {
        return this.withUid(new TokenClaimOrExpressionMapping(claim, expression));
    }

    public UidNested<A> withNewUidLike(TokenClaimOrExpressionMapping item) {
        return new UidNested(item);
    }

    public UsernameNested<A> withNewUsername() {
        return new UsernameNested(null);
    }

    public UsernameNested<A> withNewUsernameLike(UsernameClaimMapping item) {
        return new UsernameNested(item);
    }

    public A withUid(TokenClaimOrExpressionMapping uid) {
        this._visitables.remove((Object)"uid");
        if (uid != null) {
            this.uid = new TokenClaimOrExpressionMappingBuilder(uid);
            this._visitables.get((Object)"uid").add(this.uid);
        } else {
            this.uid = null;
            this._visitables.get((Object)"uid").remove((Object)this.uid);
        }
        return (A)((Object)this);
    }

    public A withUsername(UsernameClaimMapping username) {
        this._visitables.remove((Object)"username");
        if (username != null) {
            this.username = new UsernameClaimMappingBuilder(username);
            this._visitables.get((Object)"username").add(this.username);
        } else {
            this.username = null;
            this._visitables.get((Object)"username").remove((Object)this.username);
        }
        return (A)((Object)this);
    }

    public class UsernameNested<N>
    extends UsernameClaimMappingFluent<UsernameNested<N>>
    implements Nested<N> {
        UsernameClaimMappingBuilder builder;

        UsernameNested(UsernameClaimMapping item) {
            this.builder = new UsernameClaimMappingBuilder(this, item);
        }

        public N and() {
            return (N)TokenClaimMappingsFluent.this.withUsername(this.builder.build());
        }

        public N endUsername() {
            return this.and();
        }
    }

    public class UidNested<N>
    extends TokenClaimOrExpressionMappingFluent<UidNested<N>>
    implements Nested<N> {
        TokenClaimOrExpressionMappingBuilder builder;

        UidNested(TokenClaimOrExpressionMapping item) {
            this.builder = new TokenClaimOrExpressionMappingBuilder(this, item);
        }

        public N and() {
            return (N)TokenClaimMappingsFluent.this.withUid(this.builder.build());
        }

        public N endUid() {
            return this.and();
        }
    }

    public class GroupsNested<N>
    extends PrefixedClaimMappingFluent<GroupsNested<N>>
    implements Nested<N> {
        PrefixedClaimMappingBuilder builder;

        GroupsNested(PrefixedClaimMapping item) {
            this.builder = new PrefixedClaimMappingBuilder(this, item);
        }

        public N and() {
            return (N)TokenClaimMappingsFluent.this.withGroups(this.builder.build());
        }

        public N endGroups() {
            return this.and();
        }
    }

    public class ExtraNested<N>
    extends ExtraMappingFluent<ExtraNested<N>>
    implements Nested<N> {
        ExtraMappingBuilder builder;
        int index;

        ExtraNested(int index, ExtraMapping item) {
            this.index = index;
            this.builder = new ExtraMappingBuilder(this, item);
        }

        public N and() {
            return (N)TokenClaimMappingsFluent.this.setToExtra(this.index, this.builder.build());
        }

        public N endExtra() {
            return this.and();
        }
    }
}

