/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.AuthenticationSpec;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceFluent;
import io.fabric8.openshift.api.model.config.v1.DeprecatedWebhookTokenAuthenticator;
import io.fabric8.openshift.api.model.config.v1.DeprecatedWebhookTokenAuthenticatorBuilder;
import io.fabric8.openshift.api.model.config.v1.DeprecatedWebhookTokenAuthenticatorFluent;
import io.fabric8.openshift.api.model.config.v1.OIDCProvider;
import io.fabric8.openshift.api.model.config.v1.OIDCProviderBuilder;
import io.fabric8.openshift.api.model.config.v1.OIDCProviderFluent;
import io.fabric8.openshift.api.model.config.v1.WebhookTokenAuthenticator;
import io.fabric8.openshift.api.model.config.v1.WebhookTokenAuthenticatorBuilder;
import io.fabric8.openshift.api.model.config.v1.WebhookTokenAuthenticatorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AuthenticationSpecFluent<A extends AuthenticationSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ConfigMapNameReferenceBuilder oauthMetadata;
    private ArrayList<OIDCProviderBuilder> oidcProviders = new ArrayList();
    private String serviceAccountIssuer;
    private String type;
    private WebhookTokenAuthenticatorBuilder webhookTokenAuthenticator;
    private ArrayList<DeprecatedWebhookTokenAuthenticatorBuilder> webhookTokenAuthenticators = new ArrayList();

    public AuthenticationSpecFluent() {
    }

    public AuthenticationSpecFluent(AuthenticationSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToOidcProviders(Collection<OIDCProvider> items) {
        if (this.oidcProviders == null) {
            this.oidcProviders = new ArrayList();
        }
        for (OIDCProvider item : items) {
            OIDCProviderBuilder builder = new OIDCProviderBuilder(item);
            this._visitables.get((Object)"oidcProviders").add(builder);
            this.oidcProviders.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToWebhookTokenAuthenticators(Collection<DeprecatedWebhookTokenAuthenticator> items) {
        if (this.webhookTokenAuthenticators == null) {
            this.webhookTokenAuthenticators = new ArrayList();
        }
        for (DeprecatedWebhookTokenAuthenticator item : items) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
            this._visitables.get((Object)"webhookTokenAuthenticators").add(builder);
            this.webhookTokenAuthenticators.add(builder);
        }
        return (A)((Object)this);
    }

    public OidcProvidersNested<A> addNewOidcProvider() {
        return new OidcProvidersNested(-1, null);
    }

    public OidcProvidersNested<A> addNewOidcProviderLike(OIDCProvider item) {
        return new OidcProvidersNested(-1, item);
    }

    public WebhookTokenAuthenticatorsNested<A> addNewWebhookTokenAuthenticator() {
        return new WebhookTokenAuthenticatorsNested(-1, null);
    }

    public WebhookTokenAuthenticatorsNested<A> addNewWebhookTokenAuthenticatorLike(DeprecatedWebhookTokenAuthenticator item) {
        return new WebhookTokenAuthenticatorsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToOidcProviders(OIDCProvider ... items) {
        if (this.oidcProviders == null) {
            this.oidcProviders = new ArrayList();
        }
        for (OIDCProvider item : items) {
            OIDCProviderBuilder builder = new OIDCProviderBuilder(item);
            this._visitables.get((Object)"oidcProviders").add(builder);
            this.oidcProviders.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToOidcProviders(int index, OIDCProvider item) {
        if (this.oidcProviders == null) {
            this.oidcProviders = new ArrayList();
        }
        OIDCProviderBuilder builder = new OIDCProviderBuilder(item);
        if (index < 0 || index >= this.oidcProviders.size()) {
            this._visitables.get((Object)"oidcProviders").add(builder);
            this.oidcProviders.add(builder);
        } else {
            this._visitables.get((Object)"oidcProviders").add(builder);
            this.oidcProviders.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToWebhookTokenAuthenticators(DeprecatedWebhookTokenAuthenticator ... items) {
        if (this.webhookTokenAuthenticators == null) {
            this.webhookTokenAuthenticators = new ArrayList();
        }
        for (DeprecatedWebhookTokenAuthenticator item : items) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
            this._visitables.get((Object)"webhookTokenAuthenticators").add(builder);
            this.webhookTokenAuthenticators.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToWebhookTokenAuthenticators(int index, DeprecatedWebhookTokenAuthenticator item) {
        if (this.webhookTokenAuthenticators == null) {
            this.webhookTokenAuthenticators = new ArrayList();
        }
        DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
        if (index < 0 || index >= this.webhookTokenAuthenticators.size()) {
            this._visitables.get((Object)"webhookTokenAuthenticators").add(builder);
            this.webhookTokenAuthenticators.add(builder);
        } else {
            this._visitables.get((Object)"webhookTokenAuthenticators").add(builder);
            this.webhookTokenAuthenticators.add(index, builder);
        }
        return (A)((Object)this);
    }

    public OIDCProvider buildFirstOidcProvider() {
        return this.oidcProviders.get(0).build();
    }

    public DeprecatedWebhookTokenAuthenticator buildFirstWebhookTokenAuthenticator() {
        return this.webhookTokenAuthenticators.get(0).build();
    }

    public OIDCProvider buildLastOidcProvider() {
        return this.oidcProviders.get(this.oidcProviders.size() - 1).build();
    }

    public DeprecatedWebhookTokenAuthenticator buildLastWebhookTokenAuthenticator() {
        return this.webhookTokenAuthenticators.get(this.webhookTokenAuthenticators.size() - 1).build();
    }

    public OIDCProvider buildMatchingOidcProvider(Predicate<OIDCProviderBuilder> predicate) {
        for (OIDCProviderBuilder item : this.oidcProviders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public DeprecatedWebhookTokenAuthenticator buildMatchingWebhookTokenAuthenticator(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
        for (DeprecatedWebhookTokenAuthenticatorBuilder item : this.webhookTokenAuthenticators) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ConfigMapNameReference buildOauthMetadata() {
        return this.oauthMetadata != null ? this.oauthMetadata.build() : null;
    }

    public OIDCProvider buildOidcProvider(int index) {
        return this.oidcProviders.get(index).build();
    }

    public List<OIDCProvider> buildOidcProviders() {
        return this.oidcProviders != null ? AuthenticationSpecFluent.build(this.oidcProviders) : null;
    }

    public WebhookTokenAuthenticator buildWebhookTokenAuthenticator() {
        return this.webhookTokenAuthenticator != null ? this.webhookTokenAuthenticator.build() : null;
    }

    public DeprecatedWebhookTokenAuthenticator buildWebhookTokenAuthenticator(int index) {
        return this.webhookTokenAuthenticators.get(index).build();
    }

    public List<DeprecatedWebhookTokenAuthenticator> buildWebhookTokenAuthenticators() {
        return this.webhookTokenAuthenticators != null ? AuthenticationSpecFluent.build(this.webhookTokenAuthenticators) : null;
    }

    protected void copyInstance(AuthenticationSpec instance) {
        AuthenticationSpec authenticationSpec = instance = instance != null ? instance : new AuthenticationSpec();
        if (instance != null) {
            this.withOauthMetadata(instance.getOauthMetadata());
            this.withOidcProviders(instance.getOidcProviders());
            this.withServiceAccountIssuer(instance.getServiceAccountIssuer());
            this.withType(instance.getType());
            this.withWebhookTokenAuthenticator(instance.getWebhookTokenAuthenticator());
            this.withWebhookTokenAuthenticators(instance.getWebhookTokenAuthenticators());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public OidcProvidersNested<A> editFirstOidcProvider() {
        if (this.oidcProviders.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "oidcProviders"));
        }
        return this.setNewOidcProviderLike(0, this.buildOidcProvider(0));
    }

    public WebhookTokenAuthenticatorsNested<A> editFirstWebhookTokenAuthenticator() {
        if (this.webhookTokenAuthenticators.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "webhookTokenAuthenticators"));
        }
        return this.setNewWebhookTokenAuthenticatorLike(0, this.buildWebhookTokenAuthenticator(0));
    }

    public OidcProvidersNested<A> editLastOidcProvider() {
        int index = this.oidcProviders.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "oidcProviders"));
        }
        return this.setNewOidcProviderLike(index, this.buildOidcProvider(index));
    }

    public WebhookTokenAuthenticatorsNested<A> editLastWebhookTokenAuthenticator() {
        int index = this.webhookTokenAuthenticators.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "webhookTokenAuthenticators"));
        }
        return this.setNewWebhookTokenAuthenticatorLike(index, this.buildWebhookTokenAuthenticator(index));
    }

    public OidcProvidersNested<A> editMatchingOidcProvider(Predicate<OIDCProviderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.oidcProviders.size(); ++i) {
            if (!predicate.test(this.oidcProviders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "oidcProviders"));
        }
        return this.setNewOidcProviderLike(index, this.buildOidcProvider(index));
    }

    public WebhookTokenAuthenticatorsNested<A> editMatchingWebhookTokenAuthenticator(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.webhookTokenAuthenticators.size(); ++i) {
            if (!predicate.test(this.webhookTokenAuthenticators.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "webhookTokenAuthenticators"));
        }
        return this.setNewWebhookTokenAuthenticatorLike(index, this.buildWebhookTokenAuthenticator(index));
    }

    public OauthMetadataNested<A> editOauthMetadata() {
        return this.withNewOauthMetadataLike(Optional.ofNullable(this.buildOauthMetadata()).orElse(null));
    }

    public OidcProvidersNested<A> editOidcProvider(int index) {
        if (this.oidcProviders.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "oidcProviders"));
        }
        return this.setNewOidcProviderLike(index, this.buildOidcProvider(index));
    }

    public OauthMetadataNested<A> editOrNewOauthMetadata() {
        return this.withNewOauthMetadataLike(Optional.ofNullable(this.buildOauthMetadata()).orElse(new ConfigMapNameReferenceBuilder().build()));
    }

    public OauthMetadataNested<A> editOrNewOauthMetadataLike(ConfigMapNameReference item) {
        return this.withNewOauthMetadataLike(Optional.ofNullable(this.buildOauthMetadata()).orElse(item));
    }

    public WebhookTokenAuthenticatorNested<A> editOrNewWebhookTokenAuthenticator() {
        return this.withNewWebhookTokenAuthenticatorLike(Optional.ofNullable(this.buildWebhookTokenAuthenticator()).orElse(new WebhookTokenAuthenticatorBuilder().build()));
    }

    public WebhookTokenAuthenticatorNested<A> editOrNewWebhookTokenAuthenticatorLike(WebhookTokenAuthenticator item) {
        return this.withNewWebhookTokenAuthenticatorLike(Optional.ofNullable(this.buildWebhookTokenAuthenticator()).orElse(item));
    }

    public WebhookTokenAuthenticatorNested<A> editWebhookTokenAuthenticator() {
        return this.withNewWebhookTokenAuthenticatorLike(Optional.ofNullable(this.buildWebhookTokenAuthenticator()).orElse(null));
    }

    public WebhookTokenAuthenticatorsNested<A> editWebhookTokenAuthenticator(int index) {
        if (this.webhookTokenAuthenticators.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "webhookTokenAuthenticators"));
        }
        return this.setNewWebhookTokenAuthenticatorLike(index, this.buildWebhookTokenAuthenticator(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthenticationSpecFluent that = (AuthenticationSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.oauthMetadata, (Object)that.oauthMetadata)) {
            return false;
        }
        if (!Objects.equals(this.oidcProviders, that.oidcProviders)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountIssuer, that.serviceAccountIssuer)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals((Object)this.webhookTokenAuthenticator, (Object)that.webhookTokenAuthenticator)) {
            return false;
        }
        if (!Objects.equals(this.webhookTokenAuthenticators, that.webhookTokenAuthenticators)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getServiceAccountIssuer() {
        return this.serviceAccountIssuer;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingOidcProvider(Predicate<OIDCProviderBuilder> predicate) {
        for (OIDCProviderBuilder item : this.oidcProviders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingWebhookTokenAuthenticator(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
        for (DeprecatedWebhookTokenAuthenticatorBuilder item : this.webhookTokenAuthenticators) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOauthMetadata() {
        return this.oauthMetadata != null;
    }

    public boolean hasOidcProviders() {
        return this.oidcProviders != null && !this.oidcProviders.isEmpty();
    }

    public boolean hasServiceAccountIssuer() {
        return this.serviceAccountIssuer != null;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public boolean hasWebhookTokenAuthenticator() {
        return this.webhookTokenAuthenticator != null;
    }

    public boolean hasWebhookTokenAuthenticators() {
        return this.webhookTokenAuthenticators != null && !this.webhookTokenAuthenticators.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.oauthMetadata, this.oidcProviders, this.serviceAccountIssuer, this.type, this.webhookTokenAuthenticator, this.webhookTokenAuthenticators, this.additionalProperties});
    }

    public A removeAllFromOidcProviders(Collection<OIDCProvider> items) {
        if (this.oidcProviders == null) {
            return (A)((Object)this);
        }
        for (OIDCProvider item : items) {
            OIDCProviderBuilder builder = new OIDCProviderBuilder(item);
            this._visitables.get((Object)"oidcProviders").remove((Object)builder);
            this.oidcProviders.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromWebhookTokenAuthenticators(Collection<DeprecatedWebhookTokenAuthenticator> items) {
        if (this.webhookTokenAuthenticators == null) {
            return (A)((Object)this);
        }
        for (DeprecatedWebhookTokenAuthenticator item : items) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
            this._visitables.get((Object)"webhookTokenAuthenticators").remove((Object)builder);
            this.webhookTokenAuthenticators.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromOidcProviders(OIDCProvider ... items) {
        if (this.oidcProviders == null) {
            return (A)((Object)this);
        }
        for (OIDCProvider item : items) {
            OIDCProviderBuilder builder = new OIDCProviderBuilder(item);
            this._visitables.get((Object)"oidcProviders").remove((Object)builder);
            this.oidcProviders.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromWebhookTokenAuthenticators(DeprecatedWebhookTokenAuthenticator ... items) {
        if (this.webhookTokenAuthenticators == null) {
            return (A)((Object)this);
        }
        for (DeprecatedWebhookTokenAuthenticator item : items) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
            this._visitables.get((Object)"webhookTokenAuthenticators").remove((Object)builder);
            this.webhookTokenAuthenticators.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromOidcProviders(Predicate<OIDCProviderBuilder> predicate) {
        if (this.oidcProviders == null) {
            return (A)((Object)this);
        }
        Iterator<OIDCProviderBuilder> each = this.oidcProviders.iterator();
        List visitables = this._visitables.get((Object)"oidcProviders");
        while (each.hasNext()) {
            OIDCProviderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromWebhookTokenAuthenticators(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
        if (this.webhookTokenAuthenticators == null) {
            return (A)((Object)this);
        }
        Iterator<DeprecatedWebhookTokenAuthenticatorBuilder> each = this.webhookTokenAuthenticators.iterator();
        List visitables = this._visitables.get((Object)"webhookTokenAuthenticators");
        while (each.hasNext()) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public OidcProvidersNested<A> setNewOidcProviderLike(int index, OIDCProvider item) {
        return new OidcProvidersNested(index, item);
    }

    public WebhookTokenAuthenticatorsNested<A> setNewWebhookTokenAuthenticatorLike(int index, DeprecatedWebhookTokenAuthenticator item) {
        return new WebhookTokenAuthenticatorsNested(index, item);
    }

    public A setToOidcProviders(int index, OIDCProvider item) {
        if (this.oidcProviders == null) {
            this.oidcProviders = new ArrayList();
        }
        OIDCProviderBuilder builder = new OIDCProviderBuilder(item);
        if (index < 0 || index >= this.oidcProviders.size()) {
            this._visitables.get((Object)"oidcProviders").add(builder);
            this.oidcProviders.add(builder);
        } else {
            this._visitables.get((Object)"oidcProviders").add(builder);
            this.oidcProviders.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToWebhookTokenAuthenticators(int index, DeprecatedWebhookTokenAuthenticator item) {
        if (this.webhookTokenAuthenticators == null) {
            this.webhookTokenAuthenticators = new ArrayList();
        }
        DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
        if (index < 0 || index >= this.webhookTokenAuthenticators.size()) {
            this._visitables.get((Object)"webhookTokenAuthenticators").add(builder);
            this.webhookTokenAuthenticators.add(builder);
        } else {
            this._visitables.get((Object)"webhookTokenAuthenticators").add(builder);
            this.webhookTokenAuthenticators.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.oauthMetadata != null) {
            sb.append("oauthMetadata:");
            sb.append((Object)this.oauthMetadata);
            sb.append(",");
        }
        if (this.oidcProviders != null && !this.oidcProviders.isEmpty()) {
            sb.append("oidcProviders:");
            sb.append(this.oidcProviders);
            sb.append(",");
        }
        if (this.serviceAccountIssuer != null) {
            sb.append("serviceAccountIssuer:");
            sb.append(this.serviceAccountIssuer);
            sb.append(",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
            sb.append(",");
        }
        if (this.webhookTokenAuthenticator != null) {
            sb.append("webhookTokenAuthenticator:");
            sb.append((Object)this.webhookTokenAuthenticator);
            sb.append(",");
        }
        if (this.webhookTokenAuthenticators != null && !this.webhookTokenAuthenticators.isEmpty()) {
            sb.append("webhookTokenAuthenticators:");
            sb.append(this.webhookTokenAuthenticators);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public OauthMetadataNested<A> withNewOauthMetadata() {
        return new OauthMetadataNested(null);
    }

    public A withNewOauthMetadata(String name) {
        return this.withOauthMetadata(new ConfigMapNameReference(name));
    }

    public OauthMetadataNested<A> withNewOauthMetadataLike(ConfigMapNameReference item) {
        return new OauthMetadataNested(item);
    }

    public WebhookTokenAuthenticatorNested<A> withNewWebhookTokenAuthenticator() {
        return new WebhookTokenAuthenticatorNested(null);
    }

    public WebhookTokenAuthenticatorNested<A> withNewWebhookTokenAuthenticatorLike(WebhookTokenAuthenticator item) {
        return new WebhookTokenAuthenticatorNested(item);
    }

    public A withOauthMetadata(ConfigMapNameReference oauthMetadata) {
        this._visitables.remove((Object)"oauthMetadata");
        if (oauthMetadata != null) {
            this.oauthMetadata = new ConfigMapNameReferenceBuilder(oauthMetadata);
            this._visitables.get((Object)"oauthMetadata").add(this.oauthMetadata);
        } else {
            this.oauthMetadata = null;
            this._visitables.get((Object)"oauthMetadata").remove((Object)this.oauthMetadata);
        }
        return (A)((Object)this);
    }

    public A withOidcProviders(List<OIDCProvider> oidcProviders) {
        if (this.oidcProviders != null) {
            this._visitables.get((Object)"oidcProviders").clear();
        }
        if (oidcProviders != null) {
            this.oidcProviders = new ArrayList();
            for (OIDCProvider item : oidcProviders) {
                this.addToOidcProviders(item);
            }
        } else {
            this.oidcProviders = null;
        }
        return (A)((Object)this);
    }

    public A withOidcProviders(OIDCProvider ... oidcProviders) {
        if (this.oidcProviders != null) {
            this.oidcProviders.clear();
            this._visitables.remove((Object)"oidcProviders");
        }
        if (oidcProviders != null) {
            for (OIDCProvider item : oidcProviders) {
                this.addToOidcProviders(item);
            }
        }
        return (A)((Object)this);
    }

    public A withServiceAccountIssuer(String serviceAccountIssuer) {
        this.serviceAccountIssuer = serviceAccountIssuer;
        return (A)((Object)this);
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public A withWebhookTokenAuthenticator(WebhookTokenAuthenticator webhookTokenAuthenticator) {
        this._visitables.remove((Object)"webhookTokenAuthenticator");
        if (webhookTokenAuthenticator != null) {
            this.webhookTokenAuthenticator = new WebhookTokenAuthenticatorBuilder(webhookTokenAuthenticator);
            this._visitables.get((Object)"webhookTokenAuthenticator").add(this.webhookTokenAuthenticator);
        } else {
            this.webhookTokenAuthenticator = null;
            this._visitables.get((Object)"webhookTokenAuthenticator").remove((Object)this.webhookTokenAuthenticator);
        }
        return (A)((Object)this);
    }

    public A withWebhookTokenAuthenticators(List<DeprecatedWebhookTokenAuthenticator> webhookTokenAuthenticators) {
        if (this.webhookTokenAuthenticators != null) {
            this._visitables.get((Object)"webhookTokenAuthenticators").clear();
        }
        if (webhookTokenAuthenticators != null) {
            this.webhookTokenAuthenticators = new ArrayList();
            for (DeprecatedWebhookTokenAuthenticator item : webhookTokenAuthenticators) {
                this.addToWebhookTokenAuthenticators(item);
            }
        } else {
            this.webhookTokenAuthenticators = null;
        }
        return (A)((Object)this);
    }

    public A withWebhookTokenAuthenticators(DeprecatedWebhookTokenAuthenticator ... webhookTokenAuthenticators) {
        if (this.webhookTokenAuthenticators != null) {
            this.webhookTokenAuthenticators.clear();
            this._visitables.remove((Object)"webhookTokenAuthenticators");
        }
        if (webhookTokenAuthenticators != null) {
            for (DeprecatedWebhookTokenAuthenticator item : webhookTokenAuthenticators) {
                this.addToWebhookTokenAuthenticators(item);
            }
        }
        return (A)((Object)this);
    }

    public class WebhookTokenAuthenticatorsNested<N>
    extends DeprecatedWebhookTokenAuthenticatorFluent<WebhookTokenAuthenticatorsNested<N>>
    implements Nested<N> {
        DeprecatedWebhookTokenAuthenticatorBuilder builder;
        int index;

        WebhookTokenAuthenticatorsNested(int index, DeprecatedWebhookTokenAuthenticator item) {
            this.index = index;
            this.builder = new DeprecatedWebhookTokenAuthenticatorBuilder(this, item);
        }

        public N and() {
            return (N)AuthenticationSpecFluent.this.setToWebhookTokenAuthenticators(this.index, this.builder.build());
        }

        public N endWebhookTokenAuthenticator() {
            return this.and();
        }
    }

    public class WebhookTokenAuthenticatorNested<N>
    extends WebhookTokenAuthenticatorFluent<WebhookTokenAuthenticatorNested<N>>
    implements Nested<N> {
        WebhookTokenAuthenticatorBuilder builder;

        WebhookTokenAuthenticatorNested(WebhookTokenAuthenticator item) {
            this.builder = new WebhookTokenAuthenticatorBuilder(this, item);
        }

        public N and() {
            return (N)AuthenticationSpecFluent.this.withWebhookTokenAuthenticator(this.builder.build());
        }

        public N endWebhookTokenAuthenticator() {
            return this.and();
        }
    }

    public class OidcProvidersNested<N>
    extends OIDCProviderFluent<OidcProvidersNested<N>>
    implements Nested<N> {
        OIDCProviderBuilder builder;
        int index;

        OidcProvidersNested(int index, OIDCProvider item) {
            this.index = index;
            this.builder = new OIDCProviderBuilder(this, item);
        }

        public N and() {
            return (N)AuthenticationSpecFluent.this.setToOidcProviders(this.index, this.builder.build());
        }

        public N endOidcProvider() {
            return this.and();
        }
    }

    public class OauthMetadataNested<N>
    extends ConfigMapNameReferenceFluent<OauthMetadataNested<N>>
    implements Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        OauthMetadataNested(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        public N and() {
            return (N)AuthenticationSpecFluent.this.withOauthMetadata(this.builder.build());
        }

        public N endOauthMetadata() {
            return this.and();
        }
    }
}

