/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ImageTagMirrorSetSpec;
import io.fabric8.openshift.api.model.config.v1.ImageTagMirrors;
import io.fabric8.openshift.api.model.config.v1.ImageTagMirrorsBuilder;
import io.fabric8.openshift.api.model.config.v1.ImageTagMirrorsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageTagMirrorSetSpecFluent<A extends ImageTagMirrorSetSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<ImageTagMirrorsBuilder> imageTagMirrors = new ArrayList();

    public ImageTagMirrorSetSpecFluent() {
    }

    public ImageTagMirrorSetSpecFluent(ImageTagMirrorSetSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToImageTagMirrors(Collection<ImageTagMirrors> items) {
        if (this.imageTagMirrors == null) {
            this.imageTagMirrors = new ArrayList();
        }
        for (ImageTagMirrors item : items) {
            ImageTagMirrorsBuilder builder = new ImageTagMirrorsBuilder(item);
            this._visitables.get((Object)"imageTagMirrors").add(builder);
            this.imageTagMirrors.add(builder);
        }
        return (A)((Object)this);
    }

    public ImageTagMirrorsNested<A> addNewImageTagMirror() {
        return new ImageTagMirrorsNested(-1, null);
    }

    public ImageTagMirrorsNested<A> addNewImageTagMirrorLike(ImageTagMirrors item) {
        return new ImageTagMirrorsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToImageTagMirrors(ImageTagMirrors ... items) {
        if (this.imageTagMirrors == null) {
            this.imageTagMirrors = new ArrayList();
        }
        for (ImageTagMirrors item : items) {
            ImageTagMirrorsBuilder builder = new ImageTagMirrorsBuilder(item);
            this._visitables.get((Object)"imageTagMirrors").add(builder);
            this.imageTagMirrors.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToImageTagMirrors(int index, ImageTagMirrors item) {
        if (this.imageTagMirrors == null) {
            this.imageTagMirrors = new ArrayList();
        }
        ImageTagMirrorsBuilder builder = new ImageTagMirrorsBuilder(item);
        if (index < 0 || index >= this.imageTagMirrors.size()) {
            this._visitables.get((Object)"imageTagMirrors").add(builder);
            this.imageTagMirrors.add(builder);
        } else {
            this._visitables.get((Object)"imageTagMirrors").add(builder);
            this.imageTagMirrors.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ImageTagMirrors buildFirstImageTagMirror() {
        return this.imageTagMirrors.get(0).build();
    }

    public ImageTagMirrors buildImageTagMirror(int index) {
        return this.imageTagMirrors.get(index).build();
    }

    public List<ImageTagMirrors> buildImageTagMirrors() {
        return this.imageTagMirrors != null ? ImageTagMirrorSetSpecFluent.build(this.imageTagMirrors) : null;
    }

    public ImageTagMirrors buildLastImageTagMirror() {
        return this.imageTagMirrors.get(this.imageTagMirrors.size() - 1).build();
    }

    public ImageTagMirrors buildMatchingImageTagMirror(Predicate<ImageTagMirrorsBuilder> predicate) {
        for (ImageTagMirrorsBuilder item : this.imageTagMirrors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(ImageTagMirrorSetSpec instance) {
        ImageTagMirrorSetSpec imageTagMirrorSetSpec = instance = instance != null ? instance : new ImageTagMirrorSetSpec();
        if (instance != null) {
            this.withImageTagMirrors(instance.getImageTagMirrors());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ImageTagMirrorsNested<A> editFirstImageTagMirror() {
        if (this.imageTagMirrors.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "imageTagMirrors"));
        }
        return this.setNewImageTagMirrorLike(0, this.buildImageTagMirror(0));
    }

    public ImageTagMirrorsNested<A> editImageTagMirror(int index) {
        if (this.imageTagMirrors.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "imageTagMirrors"));
        }
        return this.setNewImageTagMirrorLike(index, this.buildImageTagMirror(index));
    }

    public ImageTagMirrorsNested<A> editLastImageTagMirror() {
        int index = this.imageTagMirrors.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "imageTagMirrors"));
        }
        return this.setNewImageTagMirrorLike(index, this.buildImageTagMirror(index));
    }

    public ImageTagMirrorsNested<A> editMatchingImageTagMirror(Predicate<ImageTagMirrorsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imageTagMirrors.size(); ++i) {
            if (!predicate.test(this.imageTagMirrors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "imageTagMirrors"));
        }
        return this.setNewImageTagMirrorLike(index, this.buildImageTagMirror(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageTagMirrorSetSpecFluent that = (ImageTagMirrorSetSpecFluent)((Object)o);
        if (!Objects.equals(this.imageTagMirrors, that.imageTagMirrors)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasImageTagMirrors() {
        return this.imageTagMirrors != null && !this.imageTagMirrors.isEmpty();
    }

    public boolean hasMatchingImageTagMirror(Predicate<ImageTagMirrorsBuilder> predicate) {
        for (ImageTagMirrorsBuilder item : this.imageTagMirrors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.imageTagMirrors, this.additionalProperties);
    }

    public A removeAllFromImageTagMirrors(Collection<ImageTagMirrors> items) {
        if (this.imageTagMirrors == null) {
            return (A)((Object)this);
        }
        for (ImageTagMirrors item : items) {
            ImageTagMirrorsBuilder builder = new ImageTagMirrorsBuilder(item);
            this._visitables.get((Object)"imageTagMirrors").remove((Object)builder);
            this.imageTagMirrors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromImageTagMirrors(ImageTagMirrors ... items) {
        if (this.imageTagMirrors == null) {
            return (A)((Object)this);
        }
        for (ImageTagMirrors item : items) {
            ImageTagMirrorsBuilder builder = new ImageTagMirrorsBuilder(item);
            this._visitables.get((Object)"imageTagMirrors").remove((Object)builder);
            this.imageTagMirrors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromImageTagMirrors(Predicate<ImageTagMirrorsBuilder> predicate) {
        if (this.imageTagMirrors == null) {
            return (A)((Object)this);
        }
        Iterator<ImageTagMirrorsBuilder> each = this.imageTagMirrors.iterator();
        List visitables = this._visitables.get((Object)"imageTagMirrors");
        while (each.hasNext()) {
            ImageTagMirrorsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ImageTagMirrorsNested<A> setNewImageTagMirrorLike(int index, ImageTagMirrors item) {
        return new ImageTagMirrorsNested(index, item);
    }

    public A setToImageTagMirrors(int index, ImageTagMirrors item) {
        if (this.imageTagMirrors == null) {
            this.imageTagMirrors = new ArrayList();
        }
        ImageTagMirrorsBuilder builder = new ImageTagMirrorsBuilder(item);
        if (index < 0 || index >= this.imageTagMirrors.size()) {
            this._visitables.get((Object)"imageTagMirrors").add(builder);
            this.imageTagMirrors.add(builder);
        } else {
            this._visitables.get((Object)"imageTagMirrors").add(builder);
            this.imageTagMirrors.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageTagMirrors != null && !this.imageTagMirrors.isEmpty()) {
            sb.append("imageTagMirrors:");
            sb.append(this.imageTagMirrors);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withImageTagMirrors(List<ImageTagMirrors> imageTagMirrors) {
        if (this.imageTagMirrors != null) {
            this._visitables.get((Object)"imageTagMirrors").clear();
        }
        if (imageTagMirrors != null) {
            this.imageTagMirrors = new ArrayList();
            for (ImageTagMirrors item : imageTagMirrors) {
                this.addToImageTagMirrors(item);
            }
        } else {
            this.imageTagMirrors = null;
        }
        return (A)((Object)this);
    }

    public A withImageTagMirrors(ImageTagMirrors ... imageTagMirrors) {
        if (this.imageTagMirrors != null) {
            this.imageTagMirrors.clear();
            this._visitables.remove((Object)"imageTagMirrors");
        }
        if (imageTagMirrors != null) {
            for (ImageTagMirrors item : imageTagMirrors) {
                this.addToImageTagMirrors(item);
            }
        }
        return (A)((Object)this);
    }

    public class ImageTagMirrorsNested<N>
    extends ImageTagMirrorsFluent<ImageTagMirrorsNested<N>>
    implements Nested<N> {
        ImageTagMirrorsBuilder builder;
        int index;

        ImageTagMirrorsNested(int index, ImageTagMirrors item) {
            this.index = index;
            this.builder = new ImageTagMirrorsBuilder(this, item);
        }

        public N and() {
            return (N)ImageTagMirrorSetSpecFluent.this.setToImageTagMirrors(this.index, this.builder.build());
        }

        public N endImageTagMirror() {
            return this.and();
        }
    }
}

