package io.fabric8.openshift.api.model.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConsolePluginProxyBuilder extends ConsolePluginProxyFluent<ConsolePluginProxyBuilder> implements VisitableBuilder<ConsolePluginProxy,ConsolePluginProxyBuilder>{
  public ConsolePluginProxyBuilder() {
    this(new ConsolePluginProxy());
  }
  
  public ConsolePluginProxyBuilder(ConsolePluginProxyFluent<?> fluent) {
    this(fluent, new ConsolePluginProxy());
  }
  
  public ConsolePluginProxyBuilder(ConsolePluginProxyFluent<?> fluent,ConsolePluginProxy instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConsolePluginProxyBuilder(ConsolePluginProxy instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConsolePluginProxyFluent<?> fluent;
  
  public ConsolePluginProxy build() {
    ConsolePluginProxy buildable = new ConsolePluginProxy(fluent.getAlias(),fluent.getAuthorize(),fluent.getCaCertificate(),fluent.buildService(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}