package io.fabric8.openshift.api.model.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConsolePluginProxyServiceConfigBuilder extends ConsolePluginProxyServiceConfigFluent<ConsolePluginProxyServiceConfigBuilder> implements VisitableBuilder<ConsolePluginProxyServiceConfig,ConsolePluginProxyServiceConfigBuilder>{
  public ConsolePluginProxyServiceConfigBuilder() {
    this(new ConsolePluginProxyServiceConfig());
  }
  
  public ConsolePluginProxyServiceConfigBuilder(ConsolePluginProxyServiceConfigFluent<?> fluent) {
    this(fluent, new ConsolePluginProxyServiceConfig());
  }
  
  public ConsolePluginProxyServiceConfigBuilder(ConsolePluginProxyServiceConfigFluent<?> fluent,ConsolePluginProxyServiceConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConsolePluginProxyServiceConfigBuilder(ConsolePluginProxyServiceConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConsolePluginProxyServiceConfigFluent<?> fluent;
  
  public ConsolePluginProxyServiceConfig build() {
    ConsolePluginProxyServiceConfig buildable = new ConsolePluginProxyServiceConfig(fluent.getName(),fluent.getNamespace(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}