package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleLinkListBuilder extends ConsoleLinkListFluentImpl<ConsoleLinkListBuilder> implements VisitableBuilder<ConsoleLinkList,ConsoleLinkListBuilder>{
  public ConsoleLinkListBuilder() {
    this(false);
  }
  public ConsoleLinkListBuilder(Boolean validationEnabled) {
    this(new ConsoleLinkList(), validationEnabled);
  }
  public ConsoleLinkListBuilder(ConsoleLinkListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleLinkListBuilder(ConsoleLinkListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleLinkList(), validationEnabled);
  }
  public ConsoleLinkListBuilder(ConsoleLinkListFluent<?> fluent,ConsoleLinkList instance) {
    this(fluent, instance, false);
  }
  public ConsoleLinkListBuilder(ConsoleLinkListFluent<?> fluent,ConsoleLinkList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleLinkListBuilder(ConsoleLinkList instance) {
    this(instance,false);
  }
  public ConsoleLinkListBuilder(ConsoleLinkList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConsoleLinkListFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleLinkList build() {
    ConsoleLinkList buildable = new ConsoleLinkList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}