package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleExternalLogLinkSpecBuilder extends ConsoleExternalLogLinkSpecFluentImpl<ConsoleExternalLogLinkSpecBuilder> implements VisitableBuilder<ConsoleExternalLogLinkSpec,ConsoleExternalLogLinkSpecBuilder>{
  public ConsoleExternalLogLinkSpecBuilder() {
    this(false);
  }
  public ConsoleExternalLogLinkSpecBuilder(Boolean validationEnabled) {
    this(new ConsoleExternalLogLinkSpec(), validationEnabled);
  }
  public ConsoleExternalLogLinkSpecBuilder(ConsoleExternalLogLinkSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleExternalLogLinkSpecBuilder(ConsoleExternalLogLinkSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleExternalLogLinkSpec(), validationEnabled);
  }
  public ConsoleExternalLogLinkSpecBuilder(ConsoleExternalLogLinkSpecFluent<?> fluent,ConsoleExternalLogLinkSpec instance) {
    this(fluent, instance, false);
  }
  public ConsoleExternalLogLinkSpecBuilder(ConsoleExternalLogLinkSpecFluent<?> fluent,ConsoleExternalLogLinkSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withHrefTemplate(instance.getHrefTemplate());
      fluent.withNamespaceFilter(instance.getNamespaceFilter());
      fluent.withText(instance.getText());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleExternalLogLinkSpecBuilder(ConsoleExternalLogLinkSpec instance) {
    this(instance,false);
  }
  public ConsoleExternalLogLinkSpecBuilder(ConsoleExternalLogLinkSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withHrefTemplate(instance.getHrefTemplate());
      this.withNamespaceFilter(instance.getNamespaceFilter());
      this.withText(instance.getText());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleExternalLogLinkSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleExternalLogLinkSpec build() {
    ConsoleExternalLogLinkSpec buildable = new ConsoleExternalLogLinkSpec(fluent.getHrefTemplate(),fluent.getNamespaceFilter(),fluent.getText());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}