package io.fabric8.openshift.api.model.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsolePluginSpecBuilder extends ConsolePluginSpecFluentImpl<ConsolePluginSpecBuilder> implements VisitableBuilder<ConsolePluginSpec,ConsolePluginSpecBuilder>{
  public ConsolePluginSpecBuilder() {
    this(false);
  }
  public ConsolePluginSpecBuilder(Boolean validationEnabled) {
    this(new ConsolePluginSpec(), validationEnabled);
  }
  public ConsolePluginSpecBuilder(ConsolePluginSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsolePluginSpecBuilder(ConsolePluginSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsolePluginSpec(), validationEnabled);
  }
  public ConsolePluginSpecBuilder(ConsolePluginSpecFluent<?> fluent,ConsolePluginSpec instance) {
    this(fluent, instance, false);
  }
  public ConsolePluginSpecBuilder(ConsolePluginSpecFluent<?> fluent,ConsolePluginSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withProxy(instance.getProxy());
      fluent.withService(instance.getService());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsolePluginSpecBuilder(ConsolePluginSpec instance) {
    this(instance,false);
  }
  public ConsolePluginSpecBuilder(ConsolePluginSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDisplayName(instance.getDisplayName());
      this.withProxy(instance.getProxy());
      this.withService(instance.getService());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsolePluginSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ConsolePluginSpec build() {
    ConsolePluginSpec buildable = new ConsolePluginSpec(fluent.getDisplayName(),fluent.getProxy(),fluent.getService());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}