package io.fabric8.openshift.api.model.hive.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzureMetadataBuilder extends AzureMetadataFluent<AzureMetadataBuilder> implements VisitableBuilder<AzureMetadata,AzureMetadataBuilder>{
  public AzureMetadataBuilder() {
    this(new AzureMetadata());
  }
  
  public AzureMetadataBuilder(AzureMetadataFluent<?> fluent) {
    this(fluent, new AzureMetadata());
  }
  
  public AzureMetadataBuilder(AzureMetadataFluent<?> fluent,AzureMetadata instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzureMetadataBuilder(AzureMetadata instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzureMetadataFluent<?> fluent;
  
  public AzureMetadata build() {
    AzureMetadata buildable = new AzureMetadata(fluent.getResourceGroupName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}